% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataDistribution.R
\docType{class}
\name{Normal-class}
\alias{Normal-class}
\alias{Normal}
\alias{quantile,Normal-method}
\alias{simulate,Normal,numeric-method}
\title{Normal data distribution}
\usage{
Normal(two_armed = TRUE)

\S4method{quantile}{Normal}(x, probs, n, theta, ...)

\S4method{simulate}{Normal,numeric}(object, nsim, n, theta, seed = NULL, ...)
}
\arguments{
\item{two_armed}{logical indicating if a two-armed trial is regarded}

\item{x}{outcome}

\item{probs}{vector of probabilities}

\item{n}{sample size}

\item{theta}{distribution parameter}

\item{...}{further optional arguments}

\item{object}{object of class \code{Normal}}

\item{nsim}{number of simulation runs}

\item{seed}{random seed}
}
\description{
Implements a normal data distribution for z-values given an observed z-value
and stage size.
Standard deviation is 1 and mean \ifelse{html}{\out{&theta; &radic;n}}{\eqn{\theta\sqrt n}} where
\ifelse{html}{\out{&theta;}}{\eqn{\theta}} is the standardized effect size.
The option \code{two_armed} can be set to decide whether a one-arm or a
two-arm design should be computed.
}
\details{
See \code{\link{DataDistribution-class}} for more details.
}
\examples{
datadist <- Normal(two_armed = TRUE)

}
\seealso{
see \code{\link{probability_density_function}} and
   \code{\link{cumulative_distribution_function}} to evaluate the pdf
   and the cdf, respectively.
}
