% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scores.R
\docType{methods}
\name{expected}
\alias{expected}
\alias{expected,ConditionalScore-method}
\title{Compute the expectation of a conditional score}
\usage{
expected(s, ...)

\S4method{expected}{ConditionalScore}(s, ...)
}
\arguments{
\item{s}{ConditionalScore}

\item{...}{further optional arguments}
}
\value{
an object of class \code{\link{IntegralScore}}
}
\description{
By the method \code{expected} any \code{\link{ConditionalScore}}
can be integrated over the full \ifelse{html}{\out{x<sub>1</sub>}}{\eqn{x_1}}-range and returns an
\code{\link{IntegralScore}}. I.e., for a conditional score
\ifelse{html}{\out{s(design, x<sub>1</sub>)}}{\eqn{s(design, x_1)}}
the integral \ifelse{html}{\out{&int; s(design, x<sub>1</sub>) d x<sub>1</sub>}}{\eqn{\int s(design, x_1) d x_1}}
is computed.
}
\examples{
# creates power under point mass prior
expected(ConditionalPower(Normal(), PointMassPrior(.3, 1)))

}
