% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mcmc.R
\name{model_bayes_factor_n}
\alias{model_bayes_factor_n}
\title{Computes the Bayes factor between two models from samples from their posterior distributions.}
\usage{
model_bayes_factor_n(logL1, logL2, no_samples = 100)
}
\arguments{
\item{logL1}{Samples of log likelihoods from the posterior distribution of the first graph.}

\item{logL2}{Samples of log likelihoods from the posterior distribution of the second graph.}

\item{no_samples}{Number of permutations to sample when computing the result.}
}
\value{
The Bayes factor between the two graphs given as the mean and standard
                          deviation over \code{no_samples} different permutations of the input.
}
\description{
The likelihood of a graph can be computed by integrating over all the graph parameters (with appropriate priors).
Doing this by sampling from priors is very inefficient, so we use samples from the posteriors to importance
sample the likelihood. Given two graphs, and samples from their posteriors, we can estimate the Bayes factor
between them.
}
\details{
The numerical issues with adding a lot of numbers in log space is unstable
so we get a better estimate by doing it several times on different permutations
of the data. This function calculates the mean of the Bayes factors over different permutations of the
input and estimates the standard devition.
}

