% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenstrat.R
\name{relabel}
\alias{relabel}
\title{Change labels of populations or samples}
\usage{
relabel(data, ..., outfile = tempfile(fileext = ".ind"))
}
\arguments{
\item{data}{EIGENSTRAT trio.}

\item{...}{Population/sample names to merge (each new group defined as a
character vector).}

\item{outfile}{Path to an output snp file with coordinates of excluded sites.}
}
\value{
Updated S3 EIGENSTRAT data object with an additional 'group' slot
    specifying the path to a new ind file.
#'
}
\description{
Replace population/sample names with specified group labels.
}
\examples{
\dontrun{# download an example genomic data set and prepare it for analysis
snps <- eigenstrat(download_data(dirname = tempdir()))

# group individual samples into larger populations, creating a new
# EIGENSTRAT R object
new_snps <- relabel(
    snps,
    European = c("French", "Sardinian"),
    African = c("Dinka", "Yoruba", "Mbuti", "Khomani_San"),
    Archaic = c("Vindija", "Altai", "Denisova")
)
}

}
