% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_equal_knownComp.R
\name{is_equal_knownComp}
\alias{is_equal_knownComp}
\title{Test for equality of the known components between two admixture models}
\usage{
is_equal_knownComp(comp.dist, comp.param)
}
\arguments{
\item{comp.dist}{A list with four elements corresponding to the component distributions (specified with R native names for these distributions)
involved in the two admixture models. The two first elements refer to the unknown and known components of the 1st admixture model,
and the last two ones to those of the second admixture model. If there are unknown elements, they must be specified as 'NULL' objects.
For instance, 'comp.dist' could be specified as follows: list(f1=NULL, g1='norm', f2=NULL, g2='norm').}

\item{comp.param}{A list with four elements corresponding to the parameters of the component distributions, each element being a list
itself. The names used in this list must correspond to the native R argument names for these distributions.
The two first elements refer to the parameters of unknown and known components of the 1st admixture model, and the last
two ones to those of the second admixture model. If there are unknown elements, they must be specified as 'NULL' objects.
For instance, 'comp.param' could be specified as follows: : list(f1=NULL, g1=list(mean=0,sd=1), f2=NULL, g2=list(mean=3,sd=1.1)).}
}
\value{
A boolean (TRUE if the known components are the same, otherwise FALSE).
}
\description{
Test if the known components coming from the two two-components admixture models are the same.
}
\examples{
list.comp <- list(f1 = 'norm', g1 = 'norm',
                  f2 = 'norm', g2 = 'norm')
list.param <- list(f1 = list(mean = 3, sd = 0.5), g1 = list(mean = 0, sd = 1),
                   f2 = list(mean = 2, sd = 0.3), g2 = list(mean = 0, sd = 1))
is_equal_knownComp(comp.dist = list.comp, comp.param = list.param)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
