% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_bcvacritxfl.R
\name{derive_var_bcvacritxfl}
\alias{derive_var_bcvacritxfl}
\title{Adds CRITx CRITxFL pairs to ADBCVA dataset}
\usage{
derive_var_bcvacritxfl(
  dataset_adbcva,
  paramcds = NULL,
  basetype = NULL,
  bcva_ranges = NULL,
  bcva_uplims = NULL,
  bcva_lowlims = NULL,
  additional_text = "",
  critxfl_index = NULL
)
}
\arguments{
\item{dataset_adbcva}{Input dataset (ADBCVA).}

\item{paramcds}{Vector of \code{PARAMCD} values for which to derive \code{CRITx} and \code{CRITxFL}.}

\item{basetype}{\code{BASETYPE} value for which to derive \code{CRITx} and \code{CRITxFL}.}

\item{bcva_ranges}{List containing one or more numeric vectors of length 2. For each
vector c(a,b) in \code{bcva_ranges}, a pair of variables \code{CRITx}, \code{CRITxFL} is created
with the condition: a <= \code{CHG} <= b. If criterion flags of that type are not
required, then leave as NULL.}

\item{bcva_uplims}{List containing one or more numeric elements. For each
element a in \code{bcva_uplims}, a pair of variables \code{CRITx}, \code{CRITxFL} is created
with the condition: \code{CHG} <= a. If criterion flags of that type are not
required, then leave as NULL.}

\item{bcva_lowlims}{List containing one or more numeric elements. For each
element b in \code{bcva_lowlims}, a pair of variables \code{CRITx}, \code{CRITxFL} is created
with the condition: CHG >= b. If criterion flags of that type are not required,
then leave as NULL.}

\item{additional_text}{string containing additional text to append to \code{CRITx}}

\item{critxfl_index}{positive integer detailing the first value of x to use
in "CRITxFL". If not supplied, the function takes the first available value of
x, counting up from x = 1.}
}
\value{
The input ADBCVA dataset with additional column pairs\code{CRITx}, \code{CRITxFL}.
}
\description{
Adds a criterion variables \code{CRITx} and their corresponding flags \code{CRITxFL} to an
ADBCVA dataset.
}
\details{
This function works by calling \code{derive_var_bcvacritxfl}once for each of the
elements in \code{bcva_ranges}, \code{bcva_uplims} and \code{bcva_lowlims}.
NOTE: if \code{CHG} is equal to NA, then the resulting criterion flag is also marked
as NA.
}
\examples{
library(tibble)
library(admiral)
library(admiraldev)

adbcva1 <- tribble(
  ~STUDYID, ~USUBJID, ~BASETYPE, ~PARAMCD, ~CHG,
  "XXX001", "P01", "LAST", "SBCVA", 0,
  "XXX001", "P01", "LAST", "FBCVA", 2,
  "XXX001", "P01", "LAST", "SBCVALOG", -7,
  "XXX001", "P02", "LAST", "SBCVA", -13,
  "XXX001", "P02", "LAST", "FBCVA", 5,
  "XXX001", "P02", "LAST", "SBCVALOG", 12,
  "XXX001", "P03", "LAST", "SBCVA", NA,
  "XXX001", "P03", "LAST", "FBCVA", 17
)

derive_var_bcvacritxfl(
  dataset_adbcva = adbcva1,
  paramcds = c("SBCVA", "FBCVA"),
  basetype = NULL,
  bcva_ranges = list(c(0, 5), c(-5, -1), c(10, 15)),
  bcva_uplims = list(5, 10),
  bcva_lowlims = list(8),
  additional_text = ""
)

adbcva2 <- tribble(
  ~STUDYID, ~USUBJID, ~AVISIT, ~BASETYPE, ~PARAMCD, ~AVAL, ~CHG,
  "XXX001", "P01", "BASELINE", "LAST", "SBCVA", 4, NA,
  "XXX001", "P01", "BASELINE", "LAST", "SBCVA", 6, NA,
  "XXX001", "P01", "AVERAGE BASELINE", "AVERAGE", "SBCVA", 5, NA,
  "XXX001", "P01", "WEEK 2", "LAST", "SBCVA", -3, NA,
  "XXX001", "P01", "WEEK 4", "LAST", "SBCVA", -10, NA,
  "XXX001", "P01", "WEEK 6", "LAST", "SBCVA", 12, NA,
  "XXX001", "P01", "WEEK 2", "AVERAGE", "SBCVA", -2, -7,
  "XXX001", "P01", "WEEK 4", "AVERAGE", "SBCVA", 6, 1,
  "XXX001", "P01", "WEEK 6", "AVERAGE", "SBCVA", 3, -2
)

derive_var_bcvacritxfl(
  dataset_adbcva = adbcva2,
  paramcds = c("SBCVA", "FBCVA"),
  basetype = "AVERAGE",
  bcva_ranges = list(c(0, 5), c(-10, 0)),
  bcva_lowlims = list(5),
  additional_text = " (AVERAGE)"
)

}
\author{
Edoardo Mancini
}
\keyword{der_ophtha}
