% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_utils.R
\name{convert_na_to_blanks}
\alias{convert_na_to_blanks}
\alias{convert_na_to_blanks.default}
\alias{convert_na_to_blanks.character}
\alias{convert_na_to_blanks.list}
\alias{convert_na_to_blanks.data.frame}
\title{Convert NAs Into Blank Strings}
\usage{
convert_na_to_blanks(x)

\method{convert_na_to_blanks}{default}(x)

\method{convert_na_to_blanks}{character}(x)

\method{convert_na_to_blanks}{list}(x)

\method{convert_na_to_blanks}{data.frame}(x)
}
\arguments{
\item{x}{Any R object}
}
\value{
An object of the same class as the input
}
\description{
Turn \code{NA}s to blank strings .
}
\details{
The default methods simply returns its input unchanged. The \code{character} method
turns every instance of \code{NA_character_} or \code{NA} into \code{""} while preserving \emph{all} attributes.
When given a data frame as input the function keeps all non-character columns
as is and applies the just described logic to \code{character}
all attributes such as labels are preserved.
}
\examples{
library(tibble)

convert_na_to_blanks(c("a", "b", NA, "d", NA))

df <- tibble(
  a = structure(c("a", "b", NA, "c"), label = "A"),
  b = structure(c(1, NA, 21, 9), label = "B"),
  c = structure(c(TRUE, FALSE, TRUE, TRUE), label = "C"),
  d = structure(c(NA, NA, "s", "q"), label = "D")
)
print(df)
convert_na_to_blanks(df)
}
\seealso{
Utilities for Formatting Observations: 
\code{\link{convert_blanks_to_na}()},
\code{\link{format_eoxxstt_default}()},
\code{\link{format_reason_default}()},
\code{\link{yn_to_numeric}()}
}
\author{
Sadchla Mascary
}
\concept{utils_fmt}
\keyword{utils_fmt}
