% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_first_event.R
\name{derive_param_first_event}
\alias{derive_param_first_event}
\title{Add a First Event Parameter}
\usage{
derive_param_first_event(
  dataset,
  dataset_adsl,
  dataset_source,
  filter_source,
  date_var,
  subject_keys = vars(STUDYID, USUBJID),
  set_values_to,
  check_type = "warning"
)
}
\arguments{
\item{dataset}{Input dataset

The \code{PARAMCD} variable is expected.}

\item{dataset_adsl}{ADSL input dataset

The variables specified for \code{subject_keys} are expected. For each
observation of the specified dataset a new observation is added to the
input dataset.}

\item{dataset_source}{Source dataset

All observations in the specified dataset fulfilling the condition
specified by \code{filter_source} are considered as event.

The variables specified by the \code{subject_keys} and
\code{date_var} parameter are expected.}

\item{filter_source}{Source filter

All observations in \code{dataset_source} fulfilling the specified condition are
considered as event.

For subjects with at least one event \code{AVALC} is set to \code{"Y"}, \code{AVAL} to
\code{1}, and \code{ADT} to the first date where the condition is fulfilled.

For all other subjects \code{AVALC} is set to \code{"N"}, \code{AVAL} to \code{0}, and \code{ADT} to
\code{NA}.}

\item{date_var}{Date variable

Date variable in the source dataset (\code{dataset_source}). The variable is
used to sort the source dataset. \code{ADT} is set to the specified variable for
events.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of symbols created using \code{vars()} is expected.}

\item{set_values_to}{Variables to set

A named list returned by \code{vars()} defining the variables to be set for the
new parameter, e.g. \code{vars(PARAMCD = "PD", PARAM = "Disease Progression")}
is expected. The values must be symbols, character strings, numeric values,
or \code{NA}.}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, a message is issued if the
observations of the input dataset restricted to the source parameter
(\code{source_param}) are not unique with respect to the subject keys
(\code{subject_key} parameter) and \code{ADT}.

\emph{Default}: \code{"warning"}

\emph{Permitted Values}: \code{"none"}, \code{"warning"}, \code{"error"}}
}
\value{
The input dataset with a new parameter indicating if and when an
event occurred
}
\description{
Add a new parameter for the first event occurring in a dataset. \code{AVALC} and
\code{AVAL} indicate if an event occurred and \code{ADT} is set to the date of the
first event. For example, the function can derive a parameter for the first
disease progression.
}
\details{
\enumerate{
\item The input dataset is restricted to observations fulfilling
\code{filter_source}.
\item For each subject (with respect to the variables specified for the
\code{subject_keys} parameter) the first observation (with respect to
\code{date_var}) where the event condition (\code{filter_source} parameter) is
fulfilled is selected.
\item For each observation in \code{dataset_adsl} a new observation is created. For
subjects with event \code{AVALC} is set to \code{"Y"}, \code{AVAL} to \code{1}, and \code{ADT} to
the first date where the event condition is fulfilled. For all other
subjects \code{AVALC} is set to \code{"N"}, \code{AVAL} to \code{0}, and \code{ADT} to \code{NA}.
For subjects with event all variables from \code{dataset_source} are kept. For
subjects without event all variables which are in both \code{dataset_adsl} and
\code{dataset_source} are kept.
\item The variables specified by the \code{set_values_to} parameter are added to
the new observations.
\item The new observations are added to input dataset.
}
}
\examples{
library(dplyr)
library(lubridate)

# Derive a new parameter for the first disease progression (PD)
adsl <- tibble::tribble(
  ~USUBJID, ~DTHDT,
  "1",      ymd("2022-05-13"),
  "2",      ymd(""),
  "3",      ymd("")
) \%>\%
  mutate(STUDYID = "XX1234")

adrs <- tibble::tribble(
  ~USUBJID, ~ADTC,        ~AVALC,
  "1",      "2020-01-02", "PR",
  "1",      "2020-02-01", "CR",
  "1",      "2020-03-01", "CR",
  "1",      "2020-04-01", "SD",
  "2",      "2021-06-15", "SD",
  "2",      "2021-07-16", "PD",
  "2",      "2021-09-14", "PD"
) \%>\%
  mutate(
    STUDYID = "XX1234",
    ADT = ymd(ADTC),
    PARAMCD = "OVR",
    PARAM = "Overall Response",
    ANL01FL = "Y"
  ) \%>\%
  select(-ADTC)

derive_param_first_event(
  adrs,
  dataset_adsl = adsl,
  dataset_source = adrs,
  filter_source = PARAMCD == "OVR" & AVALC == "PD",
  date_var = ADT,
  set_values_to = vars(
    PARAMCD = "PD",
    PARAM = "Disease Progression",
    ANL01FL = "Y"
  )
)

# derive parameter indicating death
derive_param_first_event(
  dataset = adrs,
  dataset_adsl = adsl,
  dataset_source = adsl,
  filter_source = !is.na(DTHDT),
  date_var = DTHDT,
  set_values_to = vars(
    PARAMCD = "DEATH",
    PARAM = "Death",
    ANL01FL = "Y"
  )
)
}
\seealso{
BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\author{
Stefan Bundfuss
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
