% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_last_dose.R
\name{derive_vars_last_dose}
\alias{derive_vars_last_dose}
\title{Derive Last Dose}
\usage{
derive_vars_last_dose(
  dataset,
  dataset_ex,
  filter_ex = NULL,
  by_vars = exprs(STUDYID, USUBJID),
  dose_id = exprs(),
  dose_date,
  analysis_date,
  single_dose_condition = EXDOSFRQ == "ONCE",
  new_vars = NULL,
  traceability_vars = NULL
)
}
\arguments{
\item{dataset}{Input dataset.
The variables specified by the \code{by_vars} and \code{analysis_date} parameters are expected.}

\item{dataset_ex}{Input EX dataset.
The variables specified by the \code{by_vars}, \code{dose_date}, \code{new_vars} parameters,
and source variables from \code{traceability_vars} parameter are expected.}

\item{filter_ex}{Filtering condition applied to EX dataset.
For example, it can be used to filter for valid dose.
Defaults to NULL.}

\item{by_vars}{Variables to join by (created by \code{rlang::exprs}).}

\item{dose_id}{Variables to identify unique dose (created by \code{rlang::exprs}).
Defaults to empty \code{exprs()}.}

\item{dose_date}{The EX dose date variable. A date or date-time object is expected.}

\item{analysis_date}{The analysis date variable. A date or date-time object is expected.}

\item{single_dose_condition}{The condition for checking if \code{dataset_ex} is single dose. An error
is issued if the condition is not true. Defaults to \code{(EXDOSFRQ == "ONCE")}.}

\item{new_vars}{Variables to keep from \code{dataset_ex}, with the option to
rename. Can either be variables created by \code{rlang::exprs} (e.g.
\code{exprs(VISIT)}), or named list returned by \code{\link[=exprs]{exprs()}} (e.g.
\code{exprs(LSTEXVIS = VISIT)}). If set to \code{NULL}, then all variables from
\code{dataset_ex} are kept without renaming. Defaults to \code{NULL}.}

\item{traceability_vars}{A named list returned by \code{\link[=exprs]{exprs()}} listing the traceability variables,
e.g. \code{exprs(LDOSEDOM = "EX", LDOSESEQ = EXSEQ)}.
The left-hand side (names of the list elements) gives the names of the traceability variables
in the returned dataset.
The right-hand side (values of the list elements) gives the values of the traceability variables
in the returned dataset.
These can be either strings or symbols referring to existing variables.}
}
\value{
Input dataset with EX source variables from last dose added.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, please use \code{derive_vars_joined()} instead.
}
\details{
Add EX source variables from last dose to the input dataset.

When doing date comparison to identify last dose, date-time imputations are done as follows:
\itemize{
\item \code{dose_date}: time is imputed to \code{00:00:00} if the variable is a date variable
\item \code{analysis_date}: time is imputed to \code{23:59:59} if the variable is a date variable
}

The last dose records are identified as follows:
\enumerate{
\item The \code{dataset_ex} is filtered using \code{filter_ex}, if provided.
This is useful for, for example, filtering for valid dose only.
\item The datasets \code{dataset} and \code{dataset_ex} are joined using \code{by_vars}.
\item The last dose is identified:
the last dose is the EX record with maximum date where \code{dose_date} is lower to or equal to
\code{analysis_date}, subject to both date values are non-NA.
The last dose is identified per \code{by_vars}.
If multiple EX records exist for the same \code{dose_date}, then either \code{dose_id}
needs to be supplied (e.g. \code{dose_id = exprs(EXSEQ)}) to identify unique records,
or an error is issued. When \code{dose_id} is supplied, the last EX record from the same \code{dose_date}
sorted by \code{dose_id} will be used to identify last dose.
\item The EX source variables (as specified in \code{new_vars}) from last dose are appended to the
\code{dataset} and returned to the user.
}

This function only works correctly for EX dataset with a structure of single dose per row.
If your study EX dataset has multiple doses per row, use \code{\link[=create_single_dose_dataset]{create_single_dose_dataset()}} to
transform the EX dataset into single dose per row structure before calling
\code{derive_vars_last_dose()}.

If variables (other than those specified in \code{by_vars}) exist in both \code{dataset} and \code{dataset_ex},
then join cannot be performed properly and an error is issued. To resolve the error, use
\code{new_vars} to either keep variables unique to \code{dataset_ex}, or use this option to rename
variables from \code{dataset_ex} (e.g. \code{new_vars = exprs(LSTEXVIS = VISIT)}).
}
\seealso{
\code{\link[=derive_var_last_dose_amt]{derive_var_last_dose_amt()}}, \code{\link[=derive_var_last_dose_date]{derive_var_last_dose_date()}},
\code{\link[=derive_var_last_dose_grp]{derive_var_last_dose_grp()}}, \code{\link[=create_single_dose_dataset]{create_single_dose_dataset()}}

Other deprecated: 
\code{\link{derive_param_extreme_event}()},
\code{\link{derive_var_basetype}()},
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_disposition_status}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_var_worst_flag}()},
\code{\link{derive_vars_disposition_reason}()},
\code{\link{format_eoxxstt_default}()},
\code{\link{format_reason_default}()}
}
\concept{deprecated}
\keyword{deprecated}
