\name{NNCH.area}
\alias{NNCH.area}
\alias{NNCH.n.area}
\alias{NNCH.k.area}
\alias{NNCH.r.area}
\alias{NNCH.a.area}
\alias{plot.narea}
\alias{NNCH.der.n.area}
\alias{NNCH.der.k.area}
\alias{NNCH.der.r.area}
\alias{NNCH.der.a.area}
\title{LoCoH (NNCH): Home Range Area }
\description{
 \code{NNCH.area} calculates the area of the homerange for different
 isopleth levels.\cr
 \cr
 \code{NNCH.k.area} for Fixed k LoCoH, computes a data frame containing
 the area of the generated homerange vs the value of \code{k} used.\cr
 \code{NNCH.r.area} for Fixed r LoCoH, computes a data frame containing
 the area of the generated homerange vs the value of \code{r} used.\cr 
 \code{NNCH.a.area} for Adaptive LoCoH, computes a data frame containing
 the area of the generated homerange vs the value of \code{a} used.\cr
 \code{NNCH.n.area} computes a data frame containing the area of the
 generated homerange vs the variable referenced by \code{n}. Called by
 \code{NNCH.k.area}, \code{NNCH.r.area}, and \code{NNCH.a.area}. \cr
 \cr
 \code{NNCH.der.n.area} computes a data frame containing the derivative
 area of the generated homerange vs the variable referenced by \code{n}.
 Called by \code{NNCH.der.k.area}, \code{NNCH.der.r.area}, and
 \code{NNCH.der.a.area}.\cr
 \code{NNCH.der.k.area} for Fixed k LoCoH, computes a data frame
 containing the derivative of the area of the generated homerange vs the
 value of \code{k} used.\cr 
 \code{NNCH.der.r.area} for Fixed r LoCoH, computes a data frame
 containing the derivative of the area of the generated homerange vs the
 value of \code{r} used.\cr
 \code{NNCH.der.a.area} for Adaptive LoCoH, computes a data frame
 containing the derivative of the area of the generated homerange vs the
 value of \code{a} used.\cr
 \cr
 \code{plot.narea} plots the data frames generated by the above functions
}
\usage{
NNCH.area(x, percent = rev(seq(10, 100, by = 10)),
          id = NULL, k = NULL, r = NULL, a = NULL, plotit = TRUE)

NNCH.k.area(x, \dots)
NNCH.a.area(x, \dots)
NNCH.r.area(x, \dots)

NNCH.der.k.area(x, \dots)
NNCH.der.a.area(x, \dots)
NNCH.der.r.area(x, \dots)

NNCH.n.area(x, n, percent = c(100,50),
            id = NULL, k = NULL, r = NULL, a = NULL)
NNCH.der.n.area(x, n, \dots)

\method{plot}{narea}(x, \dots)

}
\arguments{
 \item{x}{a home range generated using the NNCH() method}
 \item{n}{the variable to graph area against; either \code{k}, \code{r},
   or \code{a}}
 \item{percent}{the isopleths for which to calculate the area of the
   home range}
 \item{id}{character string specifying a subset of \code{x}}
 \item{k,r,a}{numeric values specifying a subset of \code{x}}
 \item{plotit}{logical.  Whether the plot should be drawn.}
 \item{\dots}{additional arguments to be passed to the functions}
}
\value{
 \code{NNCH.n.area} and \code{NNCH.der.n.area} return a data frame of
 class \code{narea}.\cr
 \code{NNCH.area} returns a data frame of class \code{hrsize}.\cr
}
\references{
  Getz, W.M. & Wilmers, C.C. (2004). A local nearest-neighbor convex-hull
  construction of home ranges and utilization
  distributions. \emph{Ecography}, \bold{in press}.
}
\author{Scott Fortmann-Roe \email{scottfr@gmail.com}\cr
Clement Calenge \email{clement.calenge@oncfs.gouv.fr}}
\note{
  These functions are useful for determining critical values of
  \code{k}, \code{r}, and \code{a}. Big jumps in the the area indicate
  that a new chunk of data has been included. Good values of \code{k},
  \code{r}, and \code{a}, usually occur before or after a large jump.
}
\seealso{ \code{\link{NNCH}} for further information about the NNCH
  method}
\examples{
\dontrun{
data(chamois)
xy <- chamois$locs

## Try a number of neighbours between 6 and 18
(nn <- NNCH(xy, k = seq(6, 18, by=3)))
(i <- NNCH.k.area(nn, percent=100))
plot(i)
(i <- NNCH.der.k.area(nn, percent=100))
plot(i)

## Try a number of neighbours between 10 and 15
(nn <- NNCH(xy, k = 10:15))
opar <- par(mfrow=c(1,2))
(i <- NNCH.k.area(nn, percent=100))
plot(i)
(i <- NNCH.der.k.area(nn, percent=100))
plot(i)
par(opar)

## 12 neighbours seem to be a good choice
nn <- NNCH(xy, k = 12)
plot(nn)

}

}
\keyword{spatial}
