

rm(list=ls())
set.seed( 2011 )

library(adapr)


source.file <-"anova.R"
project.id <- "adaprTest"
source_info <- create_source_file_dir(source.description="analyze mpg and disp by cylinder")


# Program body here


cardata.filtered <- loadFlex("read_data.R/cardata.RData")

mpgfit <- lm(mpg~cyl,cardata.filtered)

dispfit <-lm(disp~cyl,cardata.filtered)

Graph("residuals.pdf","residual fits")

plot(cardata.filtered$cyl,mpgfit$residuals)

plot(cardata.filtered$cyl,dispfit$residuals)

graphics.off()

Write(list(mpg=mpgfit,disp=dispfit),"modelfit.RData","mpg and disp ANOVA")

# End Program Body


dependency.out <- finalize_dependency()
