% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_alphas_rss.R
\name{do_alphas_rss}
\alias{do_alphas_rss}
\title{Alphas and RSS of every set of archetypoids}
\usage{
do_alphas_rss(data, subset, huge, k_subset, rand_obs, alphas_subset, 
              type_alg = "ada", PM, prob)
}
\arguments{
\item{data}{Data matrix with all the observations.}

\item{subset}{Data matrix with a sample of the \code{data} observations.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{k_subset}{Archetypoids obtained from \code{subset}.}

\item{rand_obs}{Sample observations that form \code{subset}.}

\item{alphas_subset}{Alpha coefficients related to \code{k_subset}.}

\item{type_alg}{String. Options are 'ada' for the non-robust multivariate adalara 
algorithm, 'ada_rob' for the robust multivariate adalara algorithm, 'fada' for 
the non-robust fda fadalara algorithm and 'fada_rob' for the robust fda
fadalara algorithm.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}. Needed when
\code{type_alg = 'fada'} or \code{type_alg = 'fada_rob'}.}

\item{prob}{Probability with values in [0,1]. Needed when
\code{type_alg = 'ada_rob'} or \code{type_alg = 'fada_rob'}.}
}
\value{
A list with the following elements:
\itemize{
\item rss Real number of the residual sum of squares.
\item resid_rss Matrix with the residuals.
\item alphas Matrix with the alpha values.
}
}
\description{
In the ADALARA algorithm, every time that a set of archetypoids is computed using
a sample of the data, the alpha coefficients and the associated residual sum of 
squares (RSS) for the entire data set must be computed.
}
\examples{
data(mtcars)
data <- mtcars
n <- nrow(data)
m <- 10

k <- 3 
numRep <- 2
huge <- 200

suppressWarnings(RNGversion("3.5.0"))
set.seed(1)
rand_obs_si <- sample(1:n, size = m) 

si <- data[rand_obs_si,]
ada_si <- do_ada(si, k, numRep, huge, FALSE) 

k_si <- ada_si$cases
alphas_si <- ada_si$alphas
colnames(alphas_si) <- rownames(si)     

rss_si <- do_alphas_rss(data, si, huge, k_si, rand_obs_si, alphas_si, "ada")
str(rss_si)
                                 
}
\seealso{
\code{\link{archetypoids_norm_frob}}
}
\author{
Guillermo Vinue
}
