% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_fada.R
\name{do_fada}
\alias{do_fada}
\title{Run the whole functional archetypoid analysis with the Frobenius norm}
\usage{
do_fada(subset, numArchoid, numRep, huge, compare = FALSE, PM,
              vect_tol = c(0.95, 0.9, 0.85), alpha = 0.05, 
              outl_degree = c("outl_strong", "outl_semi_strong", "outl_moderate"),
              method = "adjbox")
}
\arguments{
\item{subset}{Data to obtain archetypes. In fadalara this is a subset of the 
entire data frame.}

\item{numArchoid}{Number of archetypes/archetypoids.}

\item{numRep}{For each \code{numArch}, run the archetype algorithm \code{numRep} times.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{compare}{Boolean argument to compute the robust residual sum of squares 
to compare these results with the ones provided by \code{\link{do_fada_robust}}.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}

\item{vect_tol}{Vector the tolerance values. Default c(0.95, 0.9, 0.85).
Needed if \code{method='toler'}.}

\item{alpha}{Significance level. Default 0.05. Needed if \code{method='toler'}.}

\item{outl_degree}{Type of outlier to identify the degree of outlierness.
Default c("outl_strong", "outl_semi_strong", "outl_moderate").
Needed if \code{method='toler'}.}

\item{method}{Method to compute the outliers. Options allowed are 'adjbox' for
using adjusted boxplots for skewed distributions, and 'toler' for using
tolerance intervals.}
}
\value{
A list with the following elements:
\itemize{
\item cases: Final vector of archetypoids.
\item alphas: Alpha coefficients for the final vector of archetypoids.
\item rss: Residual sum of squares corresponding to the final vector of archetypoids.
\item rss_rob: If \code{compare_robust=TRUE}, this is the residual sum of squares using
the robust Frobenius norm. Otherwise, NULL.
\item resid: Vector of residuals.
\item outliers: Outliers.
}
}
\description{
This function executes the entire procedure involved in the functional archetypoid 
analysis. Firstly, the initial vector of archetypoids is obtained using the 
functional archetypal algorithm and finally, the optimal vector of archetypoids is 
returned.
}
\examples{
\dontrun{
library(fda)
?growth
str(growth)
hgtm <- t(growth$hgtm)

# Create basis:
basis_fd <- create.bspline.basis(c(1,ncol(hgtm)), 10)
PM <- eval.penalty(basis_fd)
# Make fd object:
temp_points <- 1:ncol(hgtm)
temp_fd <- Data2fd(argvals = temp_points, y = growth$hgtm, basisobj = basis_fd)
data_archs <- t(temp_fd$coefs)

set.seed(2018)
res_fada <- do_fada(subset = data_archs, numArchoid = 3, numRep = 5, huge = 200, 
                    compare = FALSE, PM = PM, method = "adjbox")
str(res_fada)      

set.seed(2018)
res_fada1 <- do_fada(subset = data_archs, numArchoid = 3, numRep = 5, huge = 200, 
                     compare = FALSE, PM = PM, 
                     vect_tol = c(0.95, 0.9, 0.85), alpha = 0.05, 
                     outl_degree = c("outl_strong", "outl_semi_strong", "outl_moderate"),
                     method = "toler")
str(res_fada1)                               
}
                                  
}
\references{
Epifanio, I., Functional archetype and archetypoid analysis, 2016. 
\emph{Computational Statistics and Data Analysis} \bold{104}, 24-34, 
\url{https://doi.org/10.1016/j.csda.2016.06.007}
}
\seealso{
\code{\link{stepArchetypesRawData_funct}}, \code{\link{archetypoids_funct}}
}
\author{
Guillermo Vinue, Irene Epifanio
}
