% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_shiny.R
\name{exp_shiny}
\alias{exp_shiny}
\title{Interactively explore experience data}
\usage{
exp_shiny(
  dat,
  predictors = names(dat),
  expected = names(dat)[grepl("expected", names(dat))],
  distinct_max = 25L
)
}
\arguments{
\item{dat}{An \code{exposed_df} object.}

\item{predictors}{A character vector of independent variables in \code{dat} to
include in the shiny app.}

\item{expected}{A character vector of expected values in \code{dat} to include
in the shiny app.}

\item{distinct_max}{Maximum number of distinct values allowed for \code{predictors}
to be included as "Color" and "Facets" grouping variables. This input
prevents the drawing of overly complex plots. Default value = 25.}
}
\value{
No return value. This function is called for the side effect of
launching a shiny application.
}
\description{
Launch a shiny application to interactively explore drivers of
experience.

\code{dat} must be an \code{exposed_df} object. An error will be thrown is any other
object type is passed. If \code{dat} has transactions attached, the app will
contain features for both termination and transaction studies. Otherwise,
the app will only support termination studies.

If nothing is passed to \code{predictors}, all columns names in \code{dat} will be
used (excluding the policy number, status, termination date, exposure,
transaction counts, and transaction amounts columns).

The \code{expected} argument is optional. As a default, any column names
containing the word "expected" are used.
}
\section{Layout}{
\subsection{Filters}{

The sidebar contains filtering widgets for all variables passed
to the \code{predictors} argument.
}

\subsection{Study options}{
\subsection{Grouping variables}{

This box includes widgets to select grouping variables for summarizing
experience. The "x" widget is also used as the x variable in the plot output.
Similarly, the "Color" and "Facets" widgets are used for color and facets in
the plot. Multiple faceting variables are allowed. For the table output,
"x", "Color", and "Facets" have no particular meaning beyond the order in
which of grouping variables are displayed.
}

\subsection{Study type}{

This box also includes a toggle to switch between termination studies and
transaction studies (if available).
\subsection{Termination studies}{

The expected values checkboxes are used to activate and deactivate expected
values passed to the \code{expected} argument. This impacts the table output
directly and the available "y" variables for the plot. If there are no
expected values available, this widget will not appear. The "Weight by"
widget is used to specify which column, if any, contains weights for
summarizing experience.
}

\subsection{Transaction studies}{

The transaction types checkboxes are used to activate and deactivate
transaction types that appear in the plot and table outputs. The available
transaction types are taken from the \code{trx_types} attribute of \code{dat}.
In the plot output, transaction type will always appear as a faceting
variable. The "Transactions as \% of" selector will expand the list of
available "y" variables for the plot and impact the table output directly.
Lastly, a checkbox exists that allows for all transaction types to be
aggregated into a single group.
}

}

}

\subsection{Output}{
\subsection{Plot Tab}{

This tab includes a plot and various options for customization:
\itemize{
\item y: y variable
\item Geometry: plotting geometry
\item Add Smoothing?: activate to plot loess curves
\item Free y Scales: activate to enable separate y scales in each plot.
}
}

\subsection{Table}{

This tab includes a data table.
}

\subsection{Export Data}{

This tab includes a download button that will save a copy of the summarized
experience data.
}

}

\subsection{Filter Information}{

This box contains information on the original number of exposure records,
the number of records after filters are applied, and the percentage of
records retained.
}
}

\examples{

if (interactive()) {
  study_py <- expose_py(census_dat, "2019-12-31", target_status = "Surrender")
  expected_table <- c(seq(0.005, 0.03, length.out = 10), 0.2, 0.15, rep(0.05, 3))

  study_py <- study_py |>
  mutate(expected_1 = expected_table[pol_yr],
                expected_2 = ifelse(inc_guar, 0.015, 0.03)) |>
  add_transactions(withdrawals) |>
  left_join(account_vals, by = c("pol_num", "pol_date_yr"))

  exp_shiny(study_py)
}

}
