% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{density2}
\alias{density2}
\title{Modified kernel density function}
\usage{
density2(x, reps = 999, ...)
}
\arguments{
\item{x}{numeric data vector}

\item{reps}{bootstrap iterations for SE/interval calculation; set to NULL to suppress}

\item{...}{Additional arguments passed to \code{stas::density}}
}
\value{
A list with the same components as \code{stats::density} output plus:
 \code{se}: standard error of the density
 \code{lcl}, \code{ucl}: lower and upper 95\% confidence intervals of the density
}
\description{
Modifies \code{stats::density} by:
 Adding SE and 95\% confidence intervals for the density to the output; and
 Truncating calculation (not just reporting) of density  values on from and/or to.
}
\details{
Truncation copes with cases where where no data are available outside truncation points.
Truncation is achieved by fitting the density to the data augmented by reflecting it
across each bound using the optimal bandwidth for the unaugmented data, and returning
the resulting densities for the region between the bounds.
}
\examples{
data(BCItime)
tm <- subset(BCItime, species=="ocelot")$time
dens <- density2(tm, from=0.25, to=0.75)
plot(dens$x, dens$y, type="l")
}
