% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_eaf.R
\name{export_eaf}
\alias{export_eaf}
\title{Export a transcript object to a 'ELAN' .eaf file}
\usage{
export_eaf(
  t,
  outputPath = NULL,
  filterTierNames = NULL,
  filterSectionStartsec = NULL,
  filterSectionEndsec = NULL,
  createMediaLinks = TRUE
)
}
\arguments{
\item{t}{Transcript object; transcript to be exported.}

\item{outputPath}{Character string; path where .eaf file will be saved.}

\item{filterTierNames}{Vector of character strings; names of tiers to be included. If left unspecified, all tiers will be exported.}

\item{filterSectionStartsec}{Double; start of selection in seconds.}

\item{filterSectionEndsec}{Double; end of selection in seconds.}

\item{createMediaLinks}{Logical; if \code{TRUE} media links will be created.}
}
\value{
Contents of the .eaf file (only if \code{outputPath} is left empty)
}
\description{
Advice: In most situations it is more convenient to use \code{act::corpus_export} for exporting annotation files.
}
\details{
The .eaf file will be written to the file specified in \code{outputPath}.
If \code{outputPath} is left empty, the function will return the contents of the .eaf itself.
}
\examples{
library(act)

# Get the transcript you want to export
t <- examplecorpus@transcripts[[1]]

# Create temporary file path
path <- tempfile(pattern = t@name, tmpdir = tempdir(), fileext = ".eaf")

# It makes more sense, however, to you define a destination folder
# that is easier to access on your computer
\dontrun{
path <- file.path("PATH_TO_AN_EXISTING_FOLDER_ON_YOUR_COMPUTER",
                   paste(t@name, ".eaf", sep=""))
}

# Export WITH media links
act::export_eaf(t=t, outputPath=path)

# Export WITHOUT media links
act::export_eaf(t=t, outputPath=path, createMediaLinks = FALSE)

}
\seealso{
\code{corpus_export}, \code{export_exb}, \code{export_printtranscript}, \code{export_rpraat}, \code{export_srt}, \code{export_textgrid}
}
