% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_export.R
\name{transcripts_export}
\alias{transcripts_export}
\title{Exports transcripts in different annotation formats}
\usage{
transcripts_export(
  x,
  outputFolder,
  formats,
  createMediaLinks = FALSE,
  writeOnlyModified = FALSE
)
}
\arguments{
\item{x}{Corpus object or list of transcripts.}

\item{outputFolder}{Character string; path to a folder where the transcription files will be saved.}

\item{formats}{Vector with one or more character strings; output formats, accepted values: eaf, textgrid.}

\item{createMediaLinks}{Logical; if \code{TRUE} media links will be created (affects only eaf files).}

\item{writeOnlyModified}{Logical; if \code{TRUE} only modified transcripts will be exported.}
}
\description{
There are two kinds of data accepted as input 'x' to this function:
(1) a corpus object
(2) a list of transcripts.
}
\examples{
library(act)

# Set destination folder
outputFolder <- tempdir()

# It makes more sense, however, to you define a folder
# that is easier to access on your computer
\dontrun{
outputFolder <- "PATH_TO_AN_EMPTY_FOLDER_ON_YOUR_COMPUTER"
}

# Exports all transcript objects in Praat TextGrid format
act::transcripts_export(x=examplecorpus,
                              outputFolder=outputFolder,
                              formats="textgrid")

# Exports all transcript objects in ELAN eaf format.
# By default WITHOUT creating media links
act::transcripts_export(x=examplecorpus,
                                 outputFolder=outputFolder,
                                 formats="eaf")

# Same same, but now WITH media links.
# Only Media links are only exported that are in
# the '@path.media' attribute in the transcript object(s))
act::transcripts_export(x=examplecorpus,
                                 outputFolder=outputFolder,
                                 formats="eaf",
                                 createMediaLinks=TRUE)

# Exports in 'eaf' and 'textgrid' format
act::transcripts_export(x=examplecorpus,
                                 outputFolder=outputFolder,
                                 formats=c("eaf", "textgrid"),
                                 createMediaLinks=TRUE)

# In case you do not want to export all tiers of the transcripts
# you can use the following options:
# * \code{act.export.filter.tiers.exclude}
# * \code{act.export.filter.tiers.include}
# Please see the section about setting options for act.
}
\seealso{
\link{eaf_export}, \link{textgrid_export}, \link{textgrid_import}
}
