% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_all_data.R
\name{generate_all_data}
\alias{generate_all_data}
\title{Generate simulated data}
\usage{
generate_all_data(
  n = 200,
  alpha_S = 0,
  beta_M = 0,
  tau_S = 1,
  alpha_vec = rep(1, 3),
  beta_vec = rep(1, 3),
  M.family = stats::gaussian(),
  Y.family = stats::gaussian(),
  sigma_M = 0.5,
  sigma_Y = 0.5
)
}
\arguments{
\item{n}{the sample size}

\item{alpha_S}{the parameter in M~S+X for S}

\item{beta_M}{the parameter in Y~S+M+X for M}

\item{tau_S}{the parameter in Y~S+M+X for S}

\item{alpha_vec}{the parameter in M~S+X for X}

\item{beta_vec}{the parameter in Y~S+M+X for X}

\item{M.family}{a description of the error distribution and link function to be used in the mediator model. This is the
result of a call to a family function. (See \code{\link{family}} for details of family functions.) The default
family is \code{\link{gaussian}}.}

\item{Y.family}{a description of the error distribution and link function to be used in the outcome model. This is the
result of a call to a family function. (See \code{\link{family}} for details of family functions.) The default
family is \code{\link{gaussian}}.}

\item{sigma_M}{the noise level for M~S+X}

\item{sigma_Y}{the noise level for Y~S+M+X}
}
\value{
A list with the following components:
\item{S}{exposure}
\item{M}{mediator}
\item{Y}{outcome}
\item{X}{confounder}
}
\description{
Generate simulated data
}
\examples{
out <- generate_all_data(n = 200)
summary(out$S)
summary(out$M)
summary(out$Y)
summary(out$X)

}
