% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareText.R
\name{compareText}
\alias{compareText}
\title{Compare Text}
\usage{
compareText(path_to_ocr = NULL, path_to_gold = NULL,
  remove_extra_space = TRUE, normalize = TRUE)
}
\arguments{
\item{path_to_ocr}{path to file containing OCR'd text; required}

\item{path_to_gold}{path to file containing human transcribed text; required}

\item{remove_extra_space}{a dummy indicating whether or not extra spaces should be removed from the OCR file; default is TRUE}

\item{normalize}{add a way to normalize string distance measures -- otherwise longer document means more errors, more distance}
}
\value{
levenshtein distance
}
\description{
This function calculates the edit distance between OCR'd and human transcribed file.
The function by default prints the status of the task you are trying to delete. It will show up as 'deleted' if successful
}
\examples{
\dontrun{
compare_txt(path_to_ocr="path_to_ocr_file", path_to_gold="path_to_gold_file", 
	           remove_extra_space=TRUE)
}
}

