% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_retest.R
\name{stat_retest}
\alias{stat_retest}
\title{Create a retest stat object.}
\usage{
stat_retest(
  id,
  time,
  method = c("percent_change"),
  std.beta = FALSE,
  complete.cases = FALSE
)
}
\arguments{
\item{id}{string. This is the subject id variable in the dataset. This is
necessary to keep track of which values belong to which individuals.}

\item{time}{string. This is the time variable in the dataset. This is
necessary to keep track of which values belong to which time point.}

\item{method}{string. This is the method used to calculate the difference
between outcome values across time points. Options are:
\code{percent_change} calculated by 100 * (x - y) / y where x is the earlier
time and y is the later time.}

\item{std.beta}{logical. Whether to standardize the model outcomes and
predictors/outcomes prior to analysis.}

\item{complete.cases}{logical. Whether to only include the subset of data
with no missing data for any of the outcomes, predictors, or covariates.
Note that complete cases are considering within each group - outcome
combination but across all predictor sets.}
}
\value{
An abaStat object with \code{retest} stat type.
}
\description{
This function creates a retest stat object which can be passed as input
to the \code{set_stats()} function when building an aba model. This stat performs
a test-retest analysis on data in long format. It can be used to calculate
the bias and variance of biomarkers (or any variables, for that matter)
when measured multiple times. Moreover, the result of a model fit with this
stat can be subsequently passed to the \code{aba_robust()} object in order to
test the effect of test-retest bias/variance on clinical prediction models
which can also be fit as an aba model.
}
\examples{
# use longitudinal data in healthy controls as pseudo "test-retest"
data <- adnimerge \%>\%
  dplyr::filter(
    VISCODE \%in\% c('bl' ,'m06', 'm12'),
    DX_bl == 'CU'
  )

# fit model over two groups and two endpoints
model <- data \%>\% aba_model() \%>\%
  set_groups(
    everyone(),
    CSF_ABETA_STATUS_bl == 1,
    labels = c('CU', 'CU AB-')
  ) \%>\%
  set_outcomes(
    ADAS13, MMSE,
    labels = c('ADAS13', 'MMSE')
  ) \%>\%
  set_stats(
    stat_retest(id = 'RID', time = 'VISCODE')
  ) \%>\%
  aba_fit()

# summarise model to get bias and variance estimates
model_summary <- model \%>\% aba_summary()

# plot model results like any other summary
g <- model_summary \%>\% aba_plot_coef(
  x='term', group='group', facet=c('outcome','predictor'), coord_flip=TRUE
)
}
