% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_swirls.R
\name{canvas_swirls}
\alias{canvas_swirls}
\title{Draw Swirls}
\usage{
canvas_swirls(
  colors,
  background = "#fafafa",
  iterations = 250,
  n = 250,
  curvature = 0.005,
  lwd = 0.1,
  resolution = 500
)
}
\arguments{
\item{colors}{a character (vector) specifying the color(s) used for the
artwork.}

\item{background}{a character specifying the color used for the background.}

\item{iterations}{a positive integer specifying the number of iterations of
the algorithm.}

\item{n}{a positive integer specifying the number of particles.}

\item{curvature}{a positive number specifying the curvature of the lines.
Larger values imply relatively curved lines, while lower values produce
relatively straight lines.}

\item{lwd}{expansion factor for the line width.}

\item{resolution}{resolution of the artwork in pixels per row/column.
Increasing the resolution increases the quality of the artwork but also
increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws swirling stripes on a canvas by simulating a
  particle system.
}
\examples{
\donttest{
set.seed(2)

# Simple example
canvas_swirls(colors = colorPalette("origami"))
}

}
\references{
\url{https://mattdesl.svbtle.com/generative-art-with-nodejs-and-canvas}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
