% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frugal.R
\name{Frugal}
\alias{Frugal}
\alias{A046759}
\alias{Economical}
\title{Frugal numbers}
\usage{
Frugal(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A046759}{A046759}, a \emph{Frugal} number has more digits
than the number of digits in its prime factorization including exponents. First 6 Frugal numbers are  	125, 128, 243, 256, 343, 512. Though
it doesn't matter which base we use, here we adopt only a base of 10.
}
\examples{
## generate first 5 Frugal numbers
first5 = Frugal(5)

## print without trailing 0's.
print(first5, drop0trailing = TRUE)

}
\seealso{
\code{\link{Extravagant}}, \code{\link{Equidigital}}
}
