% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_CTI.R, R/evidence_SMC.R
\name{evidence}
\alias{evidence}
\alias{evidence_CTI}
\alias{evidence_SMC}
\title{Evidence estimation with ZV-CV}
\usage{
evidence_CTI(samples, loglike, der_loglike, der_logprior, temperatures,
  temperatures_all, most_recent, obs_estim_choose, obs_estim, options)

evidence_SMC(samples, loglike, der_loglike, der_logprior, temperatures,
  temperatures_all, most_recent, obs_estim_choose, obs_estim, options)
}
\arguments{
\item{samples}{An \eqn{N} by \eqn{d} by \eqn{T} matrix of samples from the \eqn{T} power posteriors, where \eqn{N} is the number of samples and \eqn{d} is the dimension of the target distribution}

\item{loglike}{An \eqn{N} by \eqn{T} matrix of log likelihood values corresponding to \code{samples}}

\item{der_loglike}{An \eqn{N} by \eqn{d} by \eqn{T} matrix of the derivatives of the log likelihood with respect to the parameters, with parameter values corresponding to \code{samples}}

\item{der_logprior}{An \eqn{N} by \eqn{d} by \eqn{T} matrix of the derivatives of the log prior with respect to the parameters, with parameter values corresponding to \code{samples}}

\item{temperatures}{A vector of length \eqn{T} of temperatures for the power posterior temperatures}

\item{temperatures_all}{An adjusted vector of length \eqn{tau} of temperatures. Better performance should be obtained with a more conservative temperature schedule. See \code{\link{Expand_Temperatures}} for a function to adjust the temperatures.}

\item{most_recent}{A vector of length \eqn{tau} which gives the indices in the original temperatures that the new temperatures correspond to.}

\item{obs_estim_choose}{See \code{\link{zvcv}}.}

\item{obs_estim}{See \code{\link{zvcv}}.}

\item{options}{See \code{\link{zvcv}}.}
}
\value{
The function \code{evidence_CTI}  returns a list, containing the following components:
\itemize{
\item \code{log_evidence_PS1}: The 1st order quadrature estimate for the log normalising constant
\item \code{log_evidence_PS2}: The 2nd order quadrature estimate for the log normalising constant
\item \code{regression_LL}: The set of \eqn{tau} \code{zvcv} type returns for the 1st order quadrature expectations
\item \code{regression_vLL}: The set of \eqn{tau} \code{zvcv} type returns for the 2nd order quadrature expectations
}

The function \code{evidence_SMC}  returns a list, containing the following components:
\itemize{
\item \code{log_evidence}: The logged SMC estimate for the normalising constant
\item \code{regression_SMC}: The set of \eqn{tau} \code{zvcv} type returns for the expectations
}
}
\description{
The function \code{evidence_CTI} uses ZV-CV on the controlled thermodynamic integration estimator for the normalising constant.
}
\references{
Mira, A., Solgi, R., & Imparato, D. (2013). Zero variance Markov chain Monte Carlo for Bayesian estimators. Statistics and Computing, 23(5), 653-662.

South, L. F., Oates, C. J., Mira, A., & Drovandi, C. (2019). Regularised zero variance control variates for high-dimensional variance reduction. \url{https://arxiv.org/abs/1811.05073}
}
\seealso{
See \code{\link{Expand_Temperatures}} for a function that can be used to find stricter (or less stricter) temperature schedules based on the conditional effective sample size. See an example at \code{\link{VDP}} and see \link{ZVCV} for more package details.
}
\author{
Leah F. South
}
