% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIPG_main.R
\name{ZIPG_CI}
\alias{ZIPG_CI}
\title{Get confidence interval from ZIPG model}
\usage{
ZIPG_CI(ZIPG_res, type = "Wald", CI_type = "normal", alpha = 0.05)
}
\arguments{
\item{ZIPG_res}{Result from ZIPG_main()}

\item{type}{Type of hypothesis testing method, 'Wald' or 'bWald'.}

\item{CI_type}{Type of confidence interval, 'Wald','bWald' or 'pbWald'.}

\item{alpha}{We construct (1- alpha)\% confidence interval by alpha/2 and (1-alpha/2).}
}
\value{
Table of confidence interval
}
\description{
Get confidence interval from ZIPG model
}
\examples{
data(Dietary)
dat = Dietary
ZIPG_res <- ZIPG_main(data = dat$COV,
X = ~ALC01+nutrPC1+nutrPC2, X_star = ~ ALC01,
W = dat$OTU[,100], M = dat$M )
ZIPG_CI(ZIPG_res)
}
