% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mol_sel.R
\name{get_mod_sel}
\alias{get_mod_sel}
\title{Get Model Selection Criteria}
\usage{
get_mod_sel(y, mod_type, distri, stan_fit)
}
\arguments{
\item{y}{A numeric vector representing the observed data.}

\item{mod_type}{Character string indicating the model type ("zi" or "h").}

\item{distri}{Character string specifying the distribution ("poi" or "nb").}

\item{stan_fit}{A \code{stanfit} object returned by \code{get_stanfit}.}
}
\value{
A summary table of model selection criteria, including:
\describe{
\item{EAIC}{Expected Akaike Information Criterion (AIC).}
\item{EBIC}{Expected Bayesian Information Criterion (BIC).}
\item{DIC}{Deviance Information Criterion (DIC).}
\item{WAIC1}{First version of Watanabe-Akaike Information
Criterion (WAIC).}
\item{WAIC2}{Second version of Watanabe-Akaike Information
Criterion (WAIC).}
}
The summary is printed in a table format for easy interpretation.
}
\description{
Calculates model selection criteria such as AIC, BIC, DIC, and WAIC from a
Stan model fit.
}
\examples{
\donttest{
  # Generate toy data
  y_data <- data_simu(n = 60, alpha = 0.5, rho = 0.3, theta = c(5),
                      mod_type = "zi", distri = "poi")

  # Fit a small Stan model (may take > 5s on first compile)
  stan_fit <- get_stanfit(mod_type = "zi", distri = "poi", y = y_data)

  # Get model selection criteria
  get_mod_sel(y = y_data, mod_type = "zi", distri = "poi",
              stan_fit = stan_fit)
}

}
