% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{ArgumentParser-class}
\alias{ArgumentParser}
\alias{ArgumentParser-class}
\title{Parser for command-line options and arguments}
\description{
Parser for command-line options and arguments
}
\section{Fields}{

\describe{
\item{\code{cmdargs}}{list}

\item{\code{exeargs}}{character}

\item{\code{args}}{list}

\item{\code{types}}{list}

\item{\code{defaults}}{list}

\item{\code{helps}}{list}

\item{\code{usage}}{character}

\item{\code{description}}{character}
}}
\section{Methods}{

\describe{
\item{\code{add_argument(name, ..., type, default, required = FALSE, help = "", dest,
  action)}}{Add an argument.}

\item{\code{add_description(x)}}{Add a description.}

\item{\code{add_usage(x)}}{Add a usage.}

\item{\code{make_help()}}{Make and display `usage'.}
}}
\examples{
## Test
require(Xmisc)
parser <- ArgumentParser$new()
parser$add_argument('--a_str',type='character')
parser$add_argument('--b_num',type='numeric',default='0')
a_str
## character(0)
b_num
## [1] 0
parser$make_help()
## Usage:
##     /bin/exec/R ...
## Description:
## Options:
##     a_str character
##     b_num numeric   [ 0 ]

\dontrun{
## Test from a command line
R -q -e "
require(methods);require(Xmisc);
parser <- ArgumentParser\\$new();
parser\\$add_argument('--a_str',type='character');
parser\\$add_argument('--b_num',type='numeric',default='0');
printme(a_str);printme(b_num);parser\\$make_help();
" --args --a_str='Hello World!' --b_num=1
## Loading required package: Xmisc
## ## a_str ##
## [1] "Hello World!"
## ## b_num ##
## [1] 1
## ...
}
}
\author{
Xiaobei Zhao
}

