/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.Common;
import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.Workbook;
import com.miraisolutions.xlconnect.data.Column;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public abstract class ColumnBuilder
extends Common {
    private ArrayList<DataType> detectedTypes;
    private ArrayList<Cell> cells;
    private ArrayList<CellValue> values;
    private String dateTimeFormat;
    private boolean forceConversion;
    private boolean takeCached = false;
    private FormulaEvaluator evaluator = null;
    private ErrorBehavior onErrorCell;

    /*
     * WARNING - void declaration
     */
    public ColumnBuilder(int nrows, boolean forceConversion, FormulaEvaluator evaluator, ErrorBehavior onErrorCell, String dateTimeFormat) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.detectedTypes = new ArrayList(nrows);
        this.cells = new ArrayList(nrows);
        this.values = new ArrayList((int)var1_1);
        this.forceConversion = var2_2;
        this.evaluator = evaluator;
        this.takeCached = var3_3 == null;
        this.onErrorCell = onErrorCell;
        this.dateTimeFormat = dateTimeFormat;
    }

    public final void clear() {
        this.detectedTypes.clear();
        this.cells.clear();
        this.values.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void addCell(Cell c) {
        void var1_1;
        Object object;
        String msg;
        if (c == null) {
            this.addMissing();
            return;
        }
        if (c.getCellType() == 5 || c.getCellType() == 2 && c.getCachedFormulaResultType() == 5) {
            msg = "Error detected in cell " + CellUtils.formatAsString(c) + " - " + CellUtils.getErrorMessage(c.getErrorCellValue());
            this.cellError(msg);
            return;
        }
        try {
            CellValue cellValue;
            block14: {
                void var3_2;
                block13: {
                    var3_2 = msg;
                    object = this;
                    if (!((ColumnBuilder)object).takeCached) break block13;
                    object = var3_2;
                    int n = object.getCellType();
                    if (n == 2) {
                        n = object.getCachedFormulaResultType();
                    }
                    switch (n) {
                        case 3: {
                            cellValue = null;
                            break block14;
                        }
                        case 4: {
                            cellValue = object.getBooleanCellValue() ? CellValue.TRUE : CellValue.FALSE;
                            break block14;
                        }
                        case 0: {
                            cellValue = new CellValue(object.getNumericCellValue());
                            break block14;
                        }
                        case 1: {
                            cellValue = new CellValue(object.getStringCellValue());
                            break block14;
                        }
                        case 5: {
                            cellValue = CellValue.getError((int)object.getErrorCellValue());
                            break block14;
                        }
                        default: {
                            object = String.format("Could not extract value from cell with cached value type %d", n);
                            throw new RuntimeException((String)object);
                        }
                    }
                }
                cellValue = ((ColumnBuilder)object).evaluator.evaluate((Cell)var3_2);
            }
            CellValue cv = cellValue;
        }
        catch (Exception e) {
            void var2_5;
            msg = "Error when trying to evaluate cell " + CellUtils.formatAsString((Cell)msg) + " - " + var2_5.getMessage();
            this.cellError((String)var1_1);
            return;
        }
        if (object == null) {
            this.addMissing();
            return;
        }
        this.handleCell((Cell)var1_1, (CellValue)object);
    }

    protected final void addMissing() {
        this.values.add(null);
        this.cells.add(null);
        this.detectedTypes.add(DataType.Boolean);
    }

    /*
     * WARNING - void declaration
     */
    protected final void addValue(Cell c, CellValue cv, DataType dt) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.cells.add((Cell)var1_1);
        this.values.add((CellValue)var2_2);
        this.detectedTypes.add((DataType)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final Column buildBooleanColumn() {
        void var2_2;
        void var1_1;
        boolean[] colValues = new boolean[this.values.size()];
        boolean[] missing = new boolean[this.values.size()];
        Iterator<CellValue> it = this.values.iterator();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            if (cv == null) {
                missing[counter] = true;
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: {
                        colValues[counter] = cv.getBooleanValue();
                        break;
                    }
                    case Numeric: {
                        if (this.forceConversion) {
                            colValues[counter] = cv.getNumberValue() > 0.0;
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    case String: {
                        if (this.forceConversion) {
                            colValues[counter] = Boolean.parseBoolean(cv.getStringValue().toLowerCase());
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    case DateTime: {
                        missing[counter] = true;
                        this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from DateTime to Boolean - returning NA");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(var1_1, (boolean[])var2_2, DataType.Boolean);
    }

    /*
     * WARNING - void declaration
     */
    public final Column buildDateTimeColumn() {
        void var2_2;
        void var1_1;
        Date[] colValues = new Date[this.values.size()];
        boolean[] missing = new boolean[this.values.size()];
        Iterator<CellValue> it = this.values.iterator();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            if (cv == null) {
                missing[counter] = true;
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: {
                        missing[counter] = true;
                        this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from Boolean to DateTime - returning NA");
                        break;
                    }
                    case Numeric: {
                        if (this.forceConversion) {
                            if (DateUtil.isValidExcelDate((double)cv.getNumberValue())) {
                                colValues[counter] = DateUtil.getJavaDate((double)cv.getNumberValue());
                                break;
                            }
                            missing[counter] = true;
                            this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from Numeric to DateTime - returning NA");
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    case String: {
                        if (this.forceConversion) {
                            try {
                                colValues[counter] = Workbook.dateTimeFormatter.parse(cv.getStringValue(), this.dateTimeFormat);
                            }
                            catch (Exception exception) {
                                missing[counter] = true;
                                this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from String to DateTime - returning NA");
                            }
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    case DateTime: {
                        colValues[counter] = DateUtil.getJavaDate((double)cv.getNumberValue());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(var1_1, (boolean[])var2_2, DataType.DateTime);
    }

    /*
     * WARNING - void declaration
     */
    public final Column buildNumericColumn() {
        void var2_2;
        void var1_1;
        double[] colValues = new double[this.values.size()];
        boolean[] missing = new boolean[this.values.size()];
        Iterator<CellValue> it = this.values.iterator();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            if (cv == null) {
                missing[counter] = true;
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: {
                        colValues[counter] = cv.getBooleanValue() ? 1.0 : 0.0;
                        break;
                    }
                    case Numeric: {
                        colValues[counter] = cv.getNumberValue();
                        break;
                    }
                    case String: {
                        if (this.forceConversion) {
                            try {
                                colValues[counter] = Double.parseDouble(cv.getStringValue());
                            }
                            catch (NumberFormatException numberFormatException) {
                                missing[counter] = true;
                                this.addWarning("Cell " + CellUtils.formatAsString(this.cells.get(counter)) + " cannot be converted from String to Numeric - returning NA");
                            }
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    case DateTime: {
                        if (this.forceConversion) {
                            colValues[counter] = cv.getNumberValue();
                            break;
                        }
                        missing[counter] = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(var1_1, (boolean[])var2_2, DataType.Numeric);
    }

    /*
     * WARNING - void declaration
     */
    public final Column buildStringColumn() {
        void var2_2;
        void var1_1;
        String[] colValues = new String[this.values.size()];
        boolean[] missing = new boolean[this.values.size()];
        Iterator<CellValue> it = this.values.iterator();
        Iterator<Cell> jt = this.cells.iterator();
        DataFormatter fmt = new DataFormatter();
        int counter = 0;
        while (it.hasNext()) {
            CellValue cv = it.next();
            Cell cell = jt.next();
            if (cv == null) {
                missing[counter] = true;
            } else {
                switch (this.detectedTypes.get(counter)) {
                    case Boolean: 
                    case Numeric: {
                        colValues[counter] = fmt.formatCellValue(cell, this.evaluator);
                        break;
                    }
                    case DateTime: {
                        colValues[counter] = Workbook.dateTimeFormatter.format(DateUtil.getJavaDate((double)cv.getNumberValue()), this.dateTimeFormat);
                        break;
                    }
                    case String: {
                        colValues[counter] = cv.getStringValue();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown data type detected!");
                    }
                }
            }
            ++counter;
        }
        return new Column(var1_1, (boolean[])var2_2, DataType.String);
    }

    /*
     * WARNING - void declaration
     */
    protected final void cellError(String msg) {
        void var1_1;
        if (this.onErrorCell.equals((Object)ErrorBehavior.WARN)) {
            this.addMissing();
            this.addWarning(msg);
            return;
        }
        throw new IllegalArgumentException((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final DataType determineColumnType() {
        void var1_1;
        DataType columnType = DataType.Boolean;
        Iterator<DataType> it = this.detectedTypes.iterator();
        while (it.hasNext() && !columnType.equals((Object)DataType.String)) {
            void var3_3;
            DataType dt = it.next();
            if (dt.ordinal() <= columnType.ordinal()) continue;
            columnType = var3_3;
        }
        return var1_1;
    }

    protected abstract void handleCell(Cell var1, CellValue var2);
}

