/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.extractor;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.poi.POIDocument;
import org.apache.poi.POITextExtractor;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.HPSFPropertiesOnlyDocument;
import org.apache.poi.hpsf.MutablePropertySet;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.SpecialPropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.wellknown.PropertyIDMap;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HPSFPropertiesExtractor
extends POITextExtractor {
    private Closeable toClose;

    public HPSFPropertiesExtractor(POITextExtractor mainExtractor) {
        super(mainExtractor);
    }

    public HPSFPropertiesExtractor(POIDocument doc) {
        super(doc);
    }

    public HPSFPropertiesExtractor(POIFSFileSystem fs) {
        super(new HPSFPropertiesOnlyDocument(fs));
    }

    public HPSFPropertiesExtractor(NPOIFSFileSystem fs) {
        super(new HPSFPropertiesOnlyDocument(fs));
        this.toClose = fs;
    }

    public String getDocumentSummaryInformationText() {
        CustomProperties cps;
        DocumentSummaryInformation dsi = this.document.getDocumentSummaryInformation();
        StringBuffer text = new StringBuffer();
        text.append(HPSFPropertiesExtractor.getPropertiesText(dsi));
        CustomProperties customProperties = cps = dsi == null ? null : dsi.getCustomProperties();
        if (cps != null) {
            for (String key : cps.nameSet()) {
                String val = HelperPropertySet.getPropertyValueText(cps.get(key));
                text.append(key + " = " + val + "\n");
            }
        }
        return text.toString();
    }

    public String getSummaryInformationText() {
        SummaryInformation si = this.document.getSummaryInformation();
        return HPSFPropertiesExtractor.getPropertiesText(si);
    }

    private static String getPropertiesText(SpecialPropertySet ps) {
        if (ps == null) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        PropertyIDMap idMap = ps.getPropertySetIDMap();
        Property[] props = ps.getProperties();
        for (int i = 0; i < props.length; ++i) {
            String type = Long.toString(props[i].getID());
            Object typeObj = idMap.get(props[i].getID());
            if (typeObj != null) {
                type = typeObj.toString();
            }
            String val = HelperPropertySet.getPropertyValueText(props[i].getValue());
            text.append(type + " = " + val + "\n");
        }
        return text.toString();
    }

    @Override
    public String getText() {
        return this.getSummaryInformationText() + this.getDocumentSummaryInformationText();
    }

    @Override
    public POITextExtractor getMetadataTextExtractor() {
        throw new IllegalStateException("You already have the Metadata Text Extractor, not recursing!");
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.toClose != null) {
            this.toClose.close();
            this.toClose = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        for (String file : args) {
            HPSFPropertiesExtractor ext = new HPSFPropertiesExtractor(new NPOIFSFileSystem(new File(file)));
            try {
                System.out.println(ext.getText());
            }
            finally {
                ext.close();
            }
        }
    }

    private static abstract class HelperPropertySet
    extends SpecialPropertySet {
        public HelperPropertySet() {
            super((MutablePropertySet)null);
        }

        public static String getPropertyValueText(Object val) {
            if (val == null) {
                return "(not set)";
            }
            return SpecialPropertySet.getPropertyStringValue(val);
        }
    }
}

