/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import com.miraisolutions.xlconnect.Common;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class HCellStyle
extends Common
implements CellStyle {
    private final HSSFWorkbook workbook;
    private final HSSFCellStyle cellStyle;

    public HCellStyle(HSSFWorkbook workbook, HSSFCellStyle cellStyle) {
        this.workbook = workbook;
        this.cellStyle = cellStyle;
    }

    @Override
    public void setBorderBottom(short border) {
        this.cellStyle.setBorderBottom(border);
    }

    @Override
    public void setBorderLeft(short border) {
        this.cellStyle.setBorderLeft(border);
    }

    @Override
    public void setBorderRight(short border) {
        this.cellStyle.setBorderRight(border);
    }

    @Override
    public void setBorderTop(short border) {
        this.cellStyle.setBorderTop(border);
    }

    @Override
    public void setBottomBorderColor(short color) {
        this.cellStyle.setBottomBorderColor(color);
    }

    @Override
    public void setLeftBorderColor(short color) {
        this.cellStyle.setLeftBorderColor(color);
    }

    @Override
    public void setRightBorderColor(short color) {
        this.cellStyle.setRightBorderColor(color);
    }

    @Override
    public void setTopBorderColor(short color) {
        this.cellStyle.setTopBorderColor(color);
    }

    @Override
    public void setDataFormat(String format) {
        HSSFDataFormat dataFormat = this.workbook.createDataFormat();
        this.cellStyle.setDataFormat(dataFormat.getFormat(format));
    }

    @Override
    public void setFillBackgroundColor(short bg) {
        this.cellStyle.setFillBackgroundColor(bg);
    }

    @Override
    public void setFillForegroundColor(short fp) {
        this.cellStyle.setFillForegroundColor(fp);
    }

    @Override
    public void setFillPattern(short bg) {
        this.cellStyle.setFillPattern(bg);
    }

    @Override
    public void setWrapText(boolean wrap) {
        this.cellStyle.setWrapText(wrap);
    }

    public static HCellStyle create(HSSFWorkbook workbook, String name) {
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        if (name != null) {
            cellStyle.setUserStyleName(name);
        }
        return new HCellStyle(workbook, cellStyle);
    }

    public static HCellStyle get(HSSFWorkbook workbook, String name) {
        HSSFWorkbook wb = workbook;
        for (short i = 0; i < workbook.getNumCellStyles(); i = (short)(i + 1)) {
            HSSFCellStyle cs = wb.getCellStyleAt(i);
            String userStyleName = cs.getUserStyleName();
            if (userStyleName == null || !cs.getUserStyleName().equals(name)) continue;
            return new HCellStyle(workbook, cs);
        }
        return null;
    }

    public static void set(HSSFCell c, HCellStyle cs) {
        c.setCellStyle(cs.cellStyle);
    }
}

