/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect;

import com.miraisolutions.xlconnect.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellAlignment;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;

public final class XCellStyle
implements CellStyle {
    private final XSSFWorkbook workbook;
    private final int xfId;
    private final int styleXfId;
    private XSSFCellAlignment cellAlignment;

    public XCellStyle(XSSFWorkbook workbook, int xfId, int styleXfId) {
        this.workbook = workbook;
        this.xfId = xfId;
        this.styleXfId = styleXfId;
    }

    private CTXf getCoreXf() {
        if (this.xfId < 0) {
            return this.workbook.getStylesSource().getCellXfAt(0);
        }
        return this.workbook.getStylesSource().getCellXfAt(this.xfId);
    }

    private CTXf getXf() {
        if (this.styleXfId >= 0) {
            return this.workbook.getStylesSource().getCellStyleXfAt(this.styleXfId);
        }
        return this.getCoreXf();
    }

    private CTBorder getCTBorder() {
        CTXf cTXf = this.getXf();
        if (cTXf.getApplyBorder()) {
            int n = (int)cTXf.getBorderId();
            cTXf = (CTBorder)this.workbook.getStylesSource().getBorderAt(n).getCTBorder().copy();
        } else {
            cTXf = CTBorder.Factory.newInstance();
        }
        return cTXf;
    }

    private CTFill getCTFill() {
        CTXf cTXf = this.getXf();
        if (cTXf.getApplyFill()) {
            int n = (int)cTXf.getFillId();
            cTXf = (CTFill)this.workbook.getStylesSource().getFillAt(n).getCTFill().copy();
        } else {
            cTXf = CTFill.Factory.newInstance();
        }
        return cTXf;
    }

    public final void setBorderBottom(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetBottom() ? cTBorder.getBottom() : cTBorder.addNewBottom();
        if (s == 0) {
            cTBorder.unsetBottom();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        s = (short)this.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = this.getXf();
        cTBorder.setBorderId((long)s);
        cTBorder.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)s);
    }

    public final void setBorderLeft(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetLeft() ? cTBorder.getLeft() : cTBorder.addNewLeft();
        if (s == 0) {
            cTBorder.unsetLeft();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        s = (short)this.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = this.getXf();
        cTBorder.setBorderId((long)s);
        cTBorder.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)s);
    }

    public final void setBorderRight(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetRight() ? cTBorder.getRight() : cTBorder.addNewRight();
        if (s == 0) {
            cTBorder.unsetRight();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        s = (short)this.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = this.getXf();
        cTBorder.setBorderId((long)s);
        cTBorder.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)s);
    }

    public final void setBorderTop(short s) {
        CTBorderPr cTBorderPr;
        CTBorder cTBorder = this.getCTBorder();
        CTBorderPr cTBorderPr2 = cTBorderPr = cTBorder.isSetTop() ? cTBorder.getTop() : cTBorder.addNewTop();
        if (s == 0) {
            cTBorder.unsetTop();
        } else {
            cTBorderPr.setStyle(STBorderStyle.Enum.forInt((int)(s + 1)));
        }
        s = (short)this.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = this.getXf();
        cTBorder.setBorderId((long)s);
        cTBorder.setApplyBorder(true);
        this.getCoreXf().setBorderId((long)s);
    }

    public final void setBottomBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XCellStyle xCellStyle = this;
        CTBorder cTBorder = xCellStyle.getCTBorder();
        (cTBorder.isSetBottom() ? cTBorder.getBottom() : cTBorder.addNewBottom()).setColor(xSSFColor.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = xCellStyle.getXf();
        cTBorder.setBorderId((long)n);
        cTBorder.setApplyBorder(true);
        xCellStyle.getCoreXf().setBorderId((long)n);
    }

    public final void setLeftBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XCellStyle xCellStyle = this;
        CTBorder cTBorder = xCellStyle.getCTBorder();
        (cTBorder.isSetLeft() ? cTBorder.getLeft() : cTBorder.addNewLeft()).setColor(xSSFColor.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = xCellStyle.getXf();
        cTBorder.setBorderId((long)n);
        cTBorder.setApplyBorder(true);
        xCellStyle.getCoreXf().setBorderId((long)n);
    }

    public final void setRightBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XCellStyle xCellStyle = this;
        CTBorder cTBorder = xCellStyle.getCTBorder();
        (cTBorder.isSetRight() ? cTBorder.getRight() : cTBorder.addNewRight()).setColor(xSSFColor.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = xCellStyle.getXf();
        cTBorder.setBorderId((long)n);
        cTBorder.setApplyBorder(true);
        xCellStyle.getCoreXf().setBorderId((long)n);
    }

    public final void setTopBorderColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XCellStyle xCellStyle = this;
        CTBorder cTBorder = xCellStyle.getCTBorder();
        (cTBorder.isSetTop() ? cTBorder.getTop() : cTBorder.addNewTop()).setColor(xSSFColor.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putBorder(new XSSFCellBorder(cTBorder));
        cTBorder = xCellStyle.getXf();
        cTBorder.setBorderId((long)n);
        cTBorder.setApplyBorder(true);
        xCellStyle.getCoreXf().setBorderId((long)n);
    }

    public final void setDataFormat(String string) {
        short s = this.workbook.createDataFormat().getFormat(string);
        CTXf cTXf = this.getXf();
        cTXf.setApplyNumberFormat(true);
        cTXf.setNumFmtId((long)s);
        this.getCoreXf().setNumFmtId((long)s);
    }

    public final void setFillBackgroundColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XCellStyle xCellStyle = this;
        CTFill cTFill = xCellStyle.getCTFill();
        CTPatternFill cTPatternFill = cTFill.getPatternFill();
        if (cTPatternFill == null) {
            cTPatternFill = cTFill.addNewPatternFill();
        }
        cTPatternFill.setBgColor(xSSFColor.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putFill(new XSSFCellFill(cTFill));
        cTFill = xCellStyle.getXf();
        cTFill.setFillId((long)n);
        cTFill.setApplyFill(true);
        xCellStyle.getCoreXf().setFillId((long)n);
    }

    public final void setFillForegroundColor(short s) {
        XSSFColor xSSFColor = new XSSFColor();
        xSSFColor.setIndexed((int)s);
        XCellStyle xCellStyle = this;
        CTFill cTFill = xCellStyle.getCTFill();
        CTPatternFill cTPatternFill = cTFill.getPatternFill();
        if (cTPatternFill == null) {
            cTPatternFill = cTFill.addNewPatternFill();
        }
        cTPatternFill.setFgColor(xSSFColor.getCTColor());
        int n = xCellStyle.workbook.getStylesSource().putFill(new XSSFCellFill(cTFill));
        cTFill = xCellStyle.getXf();
        cTFill.setFillId((long)n);
        cTFill.setApplyFill(true);
        xCellStyle.getCoreXf().setFillId((long)n);
    }

    public final void setFillPattern(short s) {
        CTPatternFill cTPatternFill;
        CTFill cTFill = this.getCTFill();
        CTPatternFill cTPatternFill2 = cTPatternFill = cTFill.isSetPatternFill() ? cTFill.getPatternFill() : cTFill.addNewPatternFill();
        if (s == 0 && cTPatternFill.isSetPatternType()) {
            cTPatternFill.unsetPatternType();
        } else {
            cTPatternFill.setPatternType(STPatternType.Enum.forInt((int)(s + 1)));
        }
        s = (short)this.workbook.getStylesSource().putFill(new XSSFCellFill(cTFill));
        cTFill = this.getXf();
        cTFill.setFillId((long)s);
        cTFill.setApplyFill(true);
        this.getCoreXf().setFillId((long)s);
    }

    public final void setWrapText(boolean bl) {
        XCellStyle xCellStyle = this;
        if (xCellStyle.cellAlignment == null) {
            CTXf cTXf = xCellStyle.getXf();
            if (cTXf.getAlignment() == null) {
                cTXf.setAlignment(CTCellAlignment.Factory.newInstance());
            }
            xCellStyle.cellAlignment = new XSSFCellAlignment(cTXf.getAlignment());
        }
        xCellStyle.cellAlignment.setWrapText(bl);
    }

    public static void set(XSSFCell xSSFCell, XCellStyle xCellStyle) {
        if (xCellStyle.xfId < 0) {
            XCellStyle xCellStyle2 = xCellStyle;
            xCellStyle2 = xCellStyle2.workbook.getStylesSource().getCellStyleXfAt(xCellStyle2.styleXfId);
            CTXf cTXf = CTXf.Factory.newInstance();
            cTXf.setNumFmtId(xCellStyle2.getNumFmtId());
            cTXf.setFontId(xCellStyle2.getFontId());
            cTXf.setFillId(xCellStyle2.getFillId());
            cTXf.setBorderId(xCellStyle2.getBorderId());
            cTXf.setXfId((long)xCellStyle.styleXfId);
            int n = xCellStyle.workbook.getStylesSource().putCellXf(cTXf);
            xSSFCell.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(n - 1, xCellStyle.styleXfId, xCellStyle.workbook.getStylesSource(), xCellStyle.workbook.getTheme()));
            return;
        }
        if (xCellStyle.styleXfId < 0) {
            xSSFCell.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(xCellStyle.xfId, 0, xCellStyle.workbook.getStylesSource(), xCellStyle.workbook.getTheme()));
            return;
        }
        xSSFCell.setCellStyle((org.apache.poi.ss.usermodel.CellStyle)new XSSFCellStyle(xCellStyle.xfId, xCellStyle.styleXfId, xCellStyle.workbook.getStylesSource(), xCellStyle.workbook.getTheme()));
    }
}

