% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGraphSplit.r
\name{xGraphSplit}
\alias{xGraphSplit}
\title{Function to split a graph according to a node attribute}
\usage{
xGraphSplit(g, node.attr = NULL, verbose = TRUE)
}
\arguments{
\item{g}{an object of class "igraph" (or "graphNEL") for a graph with
such as a 'community' node attribute}

\item{node.attr}{a charatter specifying a node attribute. If NULL or no
match, it returns NULL}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
It returns a list of igraph objects.
}
\description{
\code{xGraphSplit} is supposed to split a graph according to a node
attribute such as community or comp.
}
\examples{
# 1) generate a random bipartite graph
set.seed(123)
g <- sample_bipartite(100, 50, p=0.1)
V(g)$name <- V(g)

\dontrun{
# 2) obtain and append the community
cs <- igraph::cluster_louvain(g)
V(g)$community <- cs$membership
ls_ig <- xGraphSplit(g, node.attr="community")
}
}
\seealso{
\code{\link{xGraphSplit}}
}
