% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGRmanhattan.r
\name{xGRmanhattan}
\alias{xGRmanhattan}
\title{Function to visualise genomic regions using manhattan plot}
\usage{
xGRmanhattan(gr, chromosome.only = TRUE, color = c("royalblue",
"sandybrown"), y.scale = c("normal", "sqrt", "log"), y.lab = NULL,
top = NULL, top.label.type = c("text", "box"), top.label.size = 2,
top.label.col = "black", top.label.force = 0.05, top.label.query =
NULL,
label.query.only = FALSE, top.label.chr = T, verbose = TRUE)
}
\arguments{
\item{gr}{a GenomicRange object with a meta-column 'value'. If the
meta-column 'label' is not provided, it will the name of this object}

\item{chromosome.only}{logical to indicate whether only those from
input data will be displayed. By default, it sets to TRUE}

\item{color}{a character vector for colors to alternate chromosome
colorings. If NULL, ggplot2 default colors will be used. If a single
character is provided, it can be "jet" (jet colormap) or "rainbow"
(rainbow colormap, that is, red-yellow-green-cyan-blue-magenta)}

\item{y.scale}{how to transform the y scale. It can be "normal" for no
transformation, "sqrt" for square root transformation, and "log" for
log-based transformation}

\item{y.lab}{the y labelling. If NULL (by default), it shows the column
of input data}

\item{top}{the number of the top targets to be labelled/highlighted}

\item{top.label.type}{how to label the top targets. It can be "box"
drawing a box around the labels , and "text" for the text only}

\item{top.label.size}{the highlight label size}

\item{top.label.col}{the highlight label color}

\item{top.label.force}{the repelling force between overlapping labels}

\item{top.label.query}{which top genes in query will be labelled. By
default, it sets to NULL meaning all top genes will be displayed. If
labels in query can not be found, then all will be displayed}

\item{label.query.only}{logical to indicate whether only those in query
will be displayed. By default, it sets to FALSE. It only works when
labels in query are enabled/found}

\item{top.label.chr}{logical to indicate whether the top hit per
chromosome will be displayed. By default, it sets to TRUE. It only
works when the parameter 'top' is null}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}
}
\value{
a ggplot object.
}
\description{
\code{xGRmanhattan} is supposed to visualise genomic regions using
manhattan plot. It returns an object of class "ggplot".
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
}

RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
\dontrun{
### GWAS catalog
GWAScatalog <- xRDataLoader('GWAScatalog',
RData.location=RData.location)
gwas <- xGR(GWAScatalog$cse_hg19, format="chr:start-end")
ind <- match(names(gwas), GWAScatalog$cse_hg19)
gwas$value <- -log10(GWAScatalog$pvalue[ind])
names(gwas) <- GWAScatalog$snp_id_current[ind]
gwas$label <- names(gwas)
gp <- xGRmanhattan(gwas)
gp
}
}
\seealso{
\code{\link{xGRmanhattan}}
}
