% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xRDataLoader.r
\name{xRDataLoader}
\alias{xRDataLoader}
\title{Function to load the package built-in RData}
\usage{
xRDataLoader(RData = c(NA, "GWAS2EF", "GWAS_LD", "IlluminaHumanHT",
"IlluminaOmniExpress", "ig.DO", "ig.EF", "ig.GOBP", "ig.GOCC",
"ig.GOMF",
"ig.HPCM", "ig.HPMA", "ig.HPMI", "ig.HPPA", "ig.MP", "org.Hs.eg",
"org.Hs.egDGIdb", "org.Hs.egDO", "org.Hs.egGOBP", "org.Hs.egGOCC",
"org.Hs.egGOMF", "org.Hs.egHPCM", "org.Hs.egHPMA", "org.Hs.egHPMI",
"org.Hs.egHPPA", "org.Hs.egMP", "org.Hs.egMsigdbC1",
"org.Hs.egMsigdbC2BIOCARTA", "org.Hs.egMsigdbC2CGP",
"org.Hs.egMsigdbC2CPall",
"org.Hs.egMsigdbC2CP", "org.Hs.egMsigdbC2KEGG",
"org.Hs.egMsigdbC2REACTOME", "org.Hs.egMsigdbC3MIR",
"org.Hs.egMsigdbC3TFT",
"org.Hs.egMsigdbC4CGN", "org.Hs.egMsigdbC4CM", "org.Hs.egMsigdbC5BP",
"org.Hs.egMsigdbC5CC", "org.Hs.egMsigdbC5MF", "org.Hs.egMsigdbC6",
"org.Hs.egMsigdbC7", "org.Hs.egMsigdbH", "org.Hs.egPS", "org.Hs.egSF",
"org.Hs.string", "org.Hs.PCommons_DN", "org.Hs.PCommons_UN"),
RData.customised = NULL, verbose = T,
RData.location =
"https://github.com/hfang-bristol/RDataCentre/blob/master/XGR/1.0.0")
}
\arguments{
\item{RData}{which built-in RData to load. It can be one of "GWAS2EF",
"GWAS_LD", "IlluminaHumanHT", "IlluminaOmniExpress", "ig.DO", "ig.EF",
"ig.GOBP", "ig.GOCC", "ig.GOMF", "ig.HPCM", "ig.HPMA", "ig.HPMI",
"ig.HPPA", "ig.MP", "org.Hs.eg", "org.Hs.egDGIdb", "org.Hs.egDO",
"org.Hs.egGOBP", "org.Hs.egGOCC", "org.Hs.egGOMF", "org.Hs.egHPCM",
"org.Hs.egHPMA", "org.Hs.egHPMI", "org.Hs.egHPPA", "org.Hs.egMP",
"org.Hs.egMsigdbC1", "org.Hs.egMsigdbC2BIOCARTA",
"org.Hs.egMsigdbC2CGP", "org.Hs.egMsigdbC2CPall",
"org.Hs.egMsigdbC2CP", "org.Hs.egMsigdbC2KEGG",
"org.Hs.egMsigdbC2REACTOME", "org.Hs.egMsigdbC3MIR",
"org.Hs.egMsigdbC3TFT", "org.Hs.egMsigdbC4CGN", "org.Hs.egMsigdbC4CM",
"org.Hs.egMsigdbC5BP", "org.Hs.egMsigdbC5CC", "org.Hs.egMsigdbC5MF",
"org.Hs.egMsigdbC6", "org.Hs.egMsigdbC7", "org.Hs.egMsigdbH",
"org.Hs.egPS", "org.Hs.egSF", "org.Hs.string", "org.Hs.PCommons_DN",
"org.Hs.PCommons_UN"}

\item{RData.customised}{a file name for RData-formatted file. By
default, it is NULL. It is designed when the user wants to import
customised RData that are not listed in the above argument 'RData'.
However, this argument can be always used even for those RData that are
listed in the argument 'RData'}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. By default, it remotely locates at
\url{https://github.com/hfang-bristol/RDataCentre/blob/master/XGR}. For
the user equipped with fast internet connection, this option can be
just left as default. But it is always advisable to download these
files locally. Especially when the user needs to run this function many
times, there is no need to ask the function to remotely download every
time (also it will unnecessarily increase the runtime). For examples,
these files (as a whole or part of them) can be first downloaded into
your current working directory, and then set this option as:
\eqn{RData.location="."}. Surely, the location can be anywhere as long
as the user provides the correct path pointing to (otherwise, the
script will have to remotely download each time)}
}
\value{
any use-specified variable that is given on the right side of the
assigement sign '<-', which contains the loaded RData.
}
\description{
\code{xRDataLoader} is supposed to load the package built-in RData.
}
\note{
If there are no use-specified variable that is given on the right side
of the assigement sign '<-', then no RData will be loaded onto the
working environment.
}
\examples{
ImmunoBase <- xRDataLoader(RData.customised='ImmunoBase')
\dontrun{
org.Hs.eg <- xRDataLoader(RData='org.Hs.eg')
ig.HPPA <- xRDataLoader(RData='ig.HPPA')
org.Hs.egHPPA <- xRDataLoader(RData='org.Hs.egHPPA')
org.Hs.egHPPA <- xRDataLoader(RData.customised='org.Hs.egHPPA')
}
}
\seealso{
\code{\link{xRDataLoader}}
}

