% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Form.R
\name{form_entriesFromCSV}
\alias{form_entriesFromCSV}
\title{Return responses of your form, from CSV format}
\usage{
form_entriesFromCSV(wufoo_name = auth_name(NULL), reportName = NULL,
  showRequestURL = FALSE, debugConnection = 0L, domain = "wufoo.com")
}
\arguments{
\item{wufoo_name}{- User's Name. Default: \code{\link{auth_name}}}

\item{reportName}{- the name of your report as displayed in the csv export 
URL (which is in lowercase with hyphens replacing spaces of your report name). Do not use 
the hash value for this argument. The report should be also public.}

\item{showRequestURL}{- use only for DEBUG purposes}

\item{debugConnection}{- samilar as above. Either "0L" (false; default) or "1L"}

\item{domain}{- for thatever reason domain's ccTLD may change. With this param you can change 
default \code{wufoo.com} to another one such as \code{wufoo.eu}}
}
\description{
This function imports your report csv file as a data frame from the report csv export url (example url below). 
The report must be publica and not protected. To verify your report csv export url, 
browse to your report, select "Export" then hover over the "Commas (.csv)" option. 
Please note that the name of your report will be in lowercase with spaces replaced with hyphens. 
For example, the report titled "My Example Report" will be "my-example-report" in the URL as shown below.
E.g. \code{https://YourName.wufoo.com/export/reports/manager/NameOfYourReport.csv}
}
\examples{
\dontrun{
options(Wufoo_Name = "johnmalc", Wufoo_API = "F1QH-Q64B-BSBI-JASJ")
df_csv <- form_entriesFromCSV(reportName = "untitled-report", showRequestURL = F)
View(df_csv)
}

}

