% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{simulated_annealing_method_options}
\alias{simulated_annealing_method_options}
\title{Options For Use With the Simulated Annealing Selection Method}
\usage{
simulated_annealing_method_options(
  force = NULL,
  method = c("binary program", "projection"),
  transport.method = transport_options(),
  OTmaxit = 100L,
  epsilon = 0.05,
  maxit = 1L,
  temps = 1000L,
  max.time = 3600,
  proposal.method = c("covariance", "uniform"),
  energy.distribution = c("boltzman", "bose-einstein"),
  cooling.schedule = c("Geman-Geman", "exponential"),
  model.size = NULL,
  display.progress = FALSE,
  parallel = NULL,
  calc.theta = TRUE,
  ...
)
}
\arguments{
\item{force}{Any covariates to force into the model? Should be by column number or NULL if no variables to force into the model.}

\item{method}{Should covariates be selected as an approximate "binary program" or should a projection method be used. Default is the approximate binary program.}

\item{transport.method}{Method for Wasserstein distance calculation. Should be one the outputs of \code{\link[=transport_options]{transport_options()}}}

\item{OTmaxit}{The number of iterations to run the Wasserstein distance solvers.}

\item{epsilon}{A value > 0 for the penalty parameter of if using the Sinkhorn method for optimal transport}

\item{maxit}{Maximum number of iterations per temperature}

\item{temps}{Number of temperatures to try}

\item{max.time}{Maximum time in seconds to run the algorithm}

\item{proposal.method}{The method to propose the next covariate to add. One of "covariance" or "random". "covariance" will randomly select from covariates with probability proportional to the absolute value of the covariance. "uniform" will select covariates uniformly at random.}

\item{energy.distribution}{The energy distribution to use for evaluating proposals. One of "boltzman" or "bose-einstein". Default is "boltzman".}

\item{cooling.schedule}{The schedule to use for cooling temperatures. One of "Geman-Geman" or "exponential". Default is "Geman-Geman".}

\item{model.size}{How many coefficients should the maximum final model have?}

\item{display.progress}{Logical. Should intermediate progress be displayed? TRUE or FALSE. Default is FALSE.}

\item{parallel}{A cluster backend to be used by \code{\link[foreach:foreach]{foreach::foreach()}}. See \code{\link[foreach:foreach]{foreach::foreach()}} for details about how to set them up. The \code{WpProj} functions will register the cluster with the \code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}} function internally.}

\item{calc.theta}{Return the linear coefficients? Default is TRUE.}

\item{...}{Not used.}
}
\value{
A named list with the above arguments
}
\description{
Options For Use With the Simulated Annealing Selection Method
}
\examples{
simulated_annealing_method_options()
}
