% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{page_external_links}
\alias{page_external_links}
\title{Retrieve a page's links}
\usage{
page_external_links(
  language = NULL,
  project = NULL,
  domain = NULL,
  page,
  protocol = NULL,
  clean_response = FALSE,
  ...
)
}
\arguments{
\item{language}{The language code of the project you wish to query,
if appropriate.}

\item{project}{The project you wish to query ("wikiquote"), if appropriate.
Should be provided in conjunction with \code{language}.}

\item{domain}{as an alternative to a \code{language} and \code{project} combination,
you can also provide a domain ("rationalwiki.org") to the URL constructor, allowing
for the querying of non-Wikimedia MediaWiki instances.}

\item{page}{the title of the page you want the links of.}

\item{protocol}{limit links to those with certain link protocols. Options are listed
in Special:ApiSandbox's
\href{https://en.wikipedia.org/wiki/Special:ApiSandbox#action=query&prop=extlinks}{elprotocol field}.}

\item{clean_response}{whether to do some basic sanitising of the resulting data structure.
Set to FALSE by default.}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
page_external_links, when provided with a page title, retrieves external wikilinks from the
current revision of that page.
}
\examples{
#Links
external_links <- page_external_links("en","wikipedia", page = "Aaron Halfaker")

#Protocol-specific links
external_http_links <- page_external_links("en","wikipedia",
                                          page = "Aaron Halfaker", protocol = "http")
}
