% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScatterHistC.R
\name{ScatterHistC}
\alias{ScatterHistC}
\title{Plot a conditional scatter plot with marginals.  xvar is the independent variable (input or model), and yvar is the dependent variable, and cvar is the condition code}
\usage{
ScatterHistC(frame, xvar, yvar, cvar, title, ..., annot_size = 3,
  colorPalette = "Dark2", adjust_x = 1, adjust_y = 1)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{yvar}{name of the dependent (output or result to be modeled) column in frame}

\item{cvar}{name of condition variable}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{annot_size}{numeric scale annotation text (if present)}

\item{colorPalette}{name of a Brewer palette (see http://colorbrewer2.org/ )}

\item{adjust_x}{numeric adjust x density plot}

\item{adjust_y}{numeric adjust y density plot}
}
\description{
Plot a conditional scatter plot with marginals.  xvar is the independent variable (input or model), and yvar is the dependent variable, and cvar is the condition code
}
\examples{

set.seed(34903490)
frm = data.frame(x=rnorm(50),y=rnorm(50))
frm$cat <- frm$x+frm$y>0
WVPlots::ScatterHistC(frm, "x", "y", "cat", title="Example Conditional Distribution")

}

