% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2d.R
\name{bin2d}
\alias{bin2d}
\title{Bin data onto a grid.}
\usage{
bin2d(data.pos, data.weights, gridsize, turn = FALSE)
}
\arguments{
\item{data.pos}{A Mx2 matrix specifying the positions of the data measure.}

\item{data.weights}{A list of vectors of the same size as the number of rows in data.pos.
All entries in the vector must be non-negative and the entries in the vector must sum to one.}

\item{gridsize}{A vector of two integers specifying the dimensions of the grid, which the data should be binned to.}

\item{turn}{A boolean specifying whether the output should be rotated to keep the previous orientation when the matrix
is plotted with the image function.}
}
\value{
A matrix containing the weights of the measure in each bin.
}
\description{
Bin data onto a equidistant grid in [0,1]^2.
}
