% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_population_catchment.R
\name{get_population_catchment}
\alias{get_population_catchment}
\title{Get population counts within catchments of sampling sites}
\usage{
get_population_catchment(
  lon,
  lat,
  path_pop_raster,
  path_dem_raster,
  path_stream_shp = NULL,
  path_output
)
}
\arguments{
\item{lon}{A numeric vector giving the longitudes of the sampling sites in Decimal Degrees.}

\item{lat}{A numeric vector giving the latitudes of the sampling sites in Decimal Degrees.}

\item{path_pop_raster}{The file path to a raster object providing population counts in each grid cell.
See \code{download_worldpop_data} for methods to download population raster data.}

\item{path_dem_raster}{The file path to a Digital Elevation Model (DEM) raster. See \code{download_elevation_data}
for methods to download DEM raster data.}

\item{path_stream_shp}{An optional file path to a stream or sewer network shapefile. If NULL (the default), streams are delineated
based on flow accumulation in the provided DEM.}

\item{path_output}{The file path of an output directory where spatial data will be saved.}
}
\value{
A \code{data.frame} containing the catchment area and population counts for each sampling site.
}
\description{
This function takes vectors of sampling site longitude and latitude and calculates the total population
residing within the drainage catchment of each coordinate pair. Raster data giving population counts per grid cell
and a Digital Elevation Model (DEM) are required. By default, the function delineates streams based on the
provided DEM. However, an optional shapefile (such as an urban sewer network) can be specified using the
\code{path_stream_shp} argument and will be used instead of the natural stream network calculated from the DEM.
Note that the delineation of catchments along streams (or sewer networks) still depends on the directional flow
from the provided DEM. Intermediate spatial variables are written to the directory specified in \code{path_output}.
}
\examples{
\donttest{

MCO_lon <- c(7.416, 7.434)
MCO_lat <- c(43.734, 43.747)

download_worldpop_data(iso3 = 'MCO',
                       year = 2020,
                       constrained = TRUE,
                       UN_adjusted = FALSE,
                       path_output = tempdir())

download_elevation_data(lon = MCO_lon,
                        lat = MCO_lat,
                        path_output = tempdir())

get_population_catchment(lon = MCO_lon,
                         lat = MCO_lat,
                         path_pop_raster = file.path(tempdir(), 'mco_ppp_2020_constrained.tif'),
                         path_dem_raster = file.path(tempdir(), 'dem.tif'),
                         path_output = tempdir())

}
}
