% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WDI.R
\name{WDI}
\alias{WDI}
\title{WDI: World Development Indicators (World Bank)}
\usage{
WDI(
  country = "all",
  indicator = "NY.GDP.PCAP.KD",
  start = 1960,
  end = 2025,
  extra = FALSE,
  cache = NULL,
  latest = NULL,
  language = "en"
)
}
\arguments{
\item{country}{Vector of countries (ISO-2 character codes, e.g. "BR", "US",
"CA") for which the data is needed. Using the string "all" instead of
individual iso codes pulls data for every available country.}

\item{indicator}{Character vector of indicators codes. See the WDIsearch()
function. If you supply a named vector, the indicators will be automatically
renamed: `c('women_private_sector' = 'BI.PWK.PRVS.FE.ZS')`}

\item{start}{Start date, usually a year in integer format. Must be 1960 or
greater.}

\item{end}{End date, usually a year in integer format. Must be greater than
the `start` argument.}

\item{extra}{TRUE returns extra variables such as region, iso3c code, and
incomeLevel. See Details.}

\item{cache}{NULL (optional) a list created by WDIcache() to be used with the extra=TRUE argument.}

\item{latest}{Integer indicating the number of most recent non-NA values to get. Default is NULL. If specified, it overrides the start and end dates.}

\item{language}{ISO-2 code in lower case indicating in which language the characters should be provided. List of languages available with `WDI::languages_supported()`. Default is English.}
}
\value{
Data frame with country-year observations. You can extract a
data.frame with indicator names and descriptive labels by inspecting the
`label` attribute of the resulting data.frame: `attr(dat, 'label')`
}
\description{
Downloads the requested data by using the World Bank's API, parses the
resulting XML file, and formats it in long country-year format.
}
\details{
It is possible to only specify the `indicator` and the `country` arguments, in which case `WDI()` will return data from 1960 to the last year available on World Bank's website. It is also possible to get only the most recent non-NA values, with `latest`.

If `extra = TRUE`, additional variables are provided:

\itemize{

\item{status: observation status, e.g is the observation a forecast?}
\item{iso3c}
\item{region}
\item{capital: name of the capital city}
\item{latitude, longitude}
\item{income: income categories of the World Bank}
\item{lending}

}
}
\examples{

\dontrun{

WDI(country="all", indicator=c("AG.AGR.TRAC.NO","TM.TAX.TCOM.BC.ZS"),
    start=1990, end=2000)
WDI(country=c("US","BR"), indicator="NY.GNS.ICTR.GN.ZS", start=1999, end=2000,
    extra=TRUE, cache=NULL)

# Rename indicators on the fly
WDI(country = 'CA', indicator = c('women_private_sector' = 'BI.PWK.PRVS.FE.ZS',
                                  'women_public_sector' = 'BI.PWK.PUBS.FE.ZS'))
                                  
# Get the 5 latest non-NA values
WDI(country=c("US","BR"), indicator="NY.GNS.ICTR.GN.ZS", latest = 5)
}

}
\author{
Vincent Arel-Bundock \email{vincent.arel-bundock@umontreal.ca}
}
