% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitNB2.R
\name{fitNB2}
\alias{fitNB2}
\title{Internal function: Fits a NB2 regression via maximum likelihood with log-link
for mean and dispersion parameter.}
\usage{
fitNB2(X, Y, family, control = controlNB())
}
\arguments{
\item{X}{Design matrix.}

\item{Y}{Count response vector.}

\item{family}{Object of class \code{"\link[WALS]{familyNBWALS}"} generated by
\code{\link[WALS]{negbinWALS}}.}

\item{control}{List of parameters for controlling the optimization process.
Use \code{\link[WALS]{controlNB}} to generate the list.}
}
\value{
A list with the following elements
\item{coefficients}{fitted coefficients from NB2 regression}
\item{theta}{fitted dispersion parameter from NB2 regression}
\item{convergence}{0 indicates successful completion. All error codes except
for \code{99} are generated by \code{\link[stats]{optim}}. Possible error
codes are
\describe{
\item{\code{1}}{indicates that the iteration limit \code{maxit} had been reached.}
\item{\code{10}}{degeneracy of the Nelder-Mead simplex.}
\item{\code{51}}{warning from "L-BFGS-B" method; see component \code{message}
for further details.}
\item{\code{52}}{error from "L-BFGS-B" method; see component \code{message}
for further details.}
\item{\code{99}}{(only possible if \code{controlNB(initMASS = TRUE)}) indicates
convergence issues in \code{\link[MASS]{glm.nb}}.}
}
}
\item{ll}{log-likelihood of fitted NB2 regression model}
\item{message}{If \code{controlNB(initMASS = FALSE)}, character string
giving any additional information returned by the optimizer, else \code{NULL}.}
\item{start}{If \code{controlNB(initMASS = FALSE)}, contains a vector with the
starting values used for \code{\link[stats]{optim}}.}
}
\description{
Internal fitting function for NB2 regression models. Used for fitting the
starting values of the one-step ML estimators in \code{\link{walsNB}}. Only
works with log-link so far, no other links tested.
}
\details{
The available parameters for controlling the optimization are documented in
\code{\link[WALS]{controlNB}}.
}
\seealso{
\link{controlNB}, \link{negbinWALS}, \link[MASS]{glm.nb}, \link{optim}.
}
