% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lssVarReg.R
\name{lssVarReg}
\alias{lssVarReg}
\title{Semi parametric location, shape and scale regression}
\usage{
lssVarReg(y, x, locationmodel = c("constant", "linear", "semi"),
  scale2model = c("constant", "linear", "semi"), shapemodel = c("constant",
  "linear"), knots.l = 2, knots.sc = 2, knots.sh = 2, degree = 2,
  mono.scale = c("none", "inc", "dec"), para.space = c("all", "positive",
  "negative"), location.init = NULL, scale2.init = NULL,
  shape.init = NULL, int.maxit = 1000, print.it = FALSE,
  control = list(...), ...)
}
\arguments{
\item{y}{Vector containing outcome data. Must be no missing data.}

\item{x}{Vector containing the covariate data, same length as \code{y}. Must be no missing data.}

\item{locationmodel}{Text to specify the location model to be fit. Options: \code{"constant"} = constant model (intercept only), \code{"linear"} = linear term with x covariate, \code{"semi"} = semiparametric spline (specify with \code{knots.l}).}

\item{scale2model}{Text to specify the scale^2 model to be fit. Options: \code{"constant"} = constant term only, \code{"linear"} = linear term with \code{x} covariate, \code{"semi"} = semiparametric spline (specify with \code{knots.sc})}

\item{shapemodel}{Text to specify the shape model to be fit. Options: \code{"constant"} = constant shape model, \code{"linear"} = linear term with x covariate, \code{"semi"} = semiparametric spline (specify with \code{knots.sh}).}

\item{knots.l}{Integer indicating the number of internal knots to be fit in the location model. Default is '2'. (Note that the knots are placed equidistantly over x.)}

\item{knots.sc}{Integer indicating the number of internal knots to be fit in the scale^2 model. Default is '2'. (Note that the knots are placed equidistantly over x.)}

\item{knots.sh}{Integer indicating the number of internal knots to be fit in the shape model. Default is '2'. (Note that the knots are placed equidistantly over x.)}

\item{degree}{Integer to indicate the degree of the splines fit in the location and scale.  Default is '2'.}

\item{mono.scale}{Text to indicate whether the scale2 model is monotonic. Default is \code{"none"} (no monotonic constraints). Options are \code{"inc"} for increasing or \code{"dec"} for decreasing. If this is chosen, the appropriate \code{para.space} is set autopmatically (\code{"positive"} for \code{inc}, \code{"negative"} for \code{dec}).}

\item{para.space}{Text to indicate the parameter space to search for scale2 parameter estimates. \code{"positive"} means only search positive parameter space, \code{"negative"} means search only negative parameter space and \code{"all"} means search all parameter spaces. Default is \code{all}.}

\item{location.init}{Vector of initial parameter estimates for the location model. Defaults to vector of 1's of appropriate length.}

\item{scale2.init}{Vector of initial parameter estimates for the scale^2 model. Defaults to vector of 1's of appropriate length.}

\item{shape.init}{Vector of initial parameter estimates for the shape model. Defaults to vector of 1's of appropriate length.}

\item{int.maxit}{Integer of maximum iterations for the internal location and scale EM algorithm. Default is 1000 iterations.}

\item{print.it}{Logical for printing progress of estimates through each iteration. Default is \code{FALSE}.}

\item{control}{List of control parameters for the algorithm. See \code{\link{VarReg.control}}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied
directly}
}
\value{
\code{lssVarReg} returns an object of class \code{"lssVarReg"}, which inherits most from class
\code{"VarReg"}. This object of class \code{lssVarReg} is a list of the following components:
\itemize{
\item \code{modeltype}: Text indicating the model that was fit, always "LSS model".
\item \code{locationmodel}, \code{scale2model}, \code{shapemodel}, \code{knots.l}, \code{knots.sc},
\code{knots.sh}, \code{degree},\code{mono.scale} : Returning the input variables as described above
\item\code{converged}: Logical argument indicating if convergence occurred.
\item\code{iterations}: Total iterations performed of the main algorithm (not including the
 internal EM algorithm).
 \item\code{reldiff}: the positive convergence tolerance that occured at the final iteration.
 \item\code{loglik}: Numeric variable of the maximised log-likelihood.
 \item\code{aic.c}: Akaike information criterion corrected for small samples
 \item\code{aic}: Akaike information criterion
 \item\code{bic}: Bayesian information criterion
 \item\code{hqc}: Hannan-Quinn information criterion
 \item\code{location}: Vector of the maximum likelihood estimates of the location parameters.
 \item\code{scale2}: Vector of the maximum likelihood estimates of the scale (squared) parameters.
 \item\code{shape}: Vector of the maximum likelihood estimates of the shape parameters.
 \item\code{data}: Dataframe containing the variables included in the model.
 }
}
\description{
\code{lssVarReg} performs a semiparametric location (\eqn{\xi} or xi), shape (\eqn{\nu} or nu) and scale (\eqn{\omega} or omega) regression model. Currently, this is only designed for a single covariate that is fit in the location, scale and shape models.
}
\examples{
## run a model with linear mean, linear variance and constant shape (not run):
## lssmodel<-lssVarReg(mcycle$accel, mcycle$times,  locationmodel="linear", scale2model="linear",
## shapemodel="constant",  maxit=10000)
}
\seealso{
\code{\link{VarReg.control}}  \code{\link{plotlssVarReg}}
}
