% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_avg_contour}
\alias{plot_avg_contour}
\title{Plots average contour surface of looks to a given interest area.}
\usage{
plot_avg_contour(data, IA = NULL, type = NULL, Var = NULL,
  VarLabel = NULL, xlim = NA, VWPreTheme = TRUE, Colors = c("gray20",
  "gray90"))
}
\arguments{
\item{data}{A data table object output by either \code{\link{bin_prop}}. 
\code{\link{transform_to_elogit}}, or \code{\link{create_binomial}}.}

\item{IA}{A string specifying the column name of the IA to use.}

\item{type}{A character string indicating "proportion" or "elogit".}

\item{Var}{A string containing the column name corresponding to the continuous
variable.}

\item{VarLabel}{A string specifying the axis label to use for \code{Var}.}

\item{xlim}{A vector of two integers specifying the limits of the x-axis.}

\item{VWPreTheme}{A logical indicating whether the theme included with the 
function, or ggplot2's base theme (which any other custom theme could be added).}

\item{Colors}{A vector of two strings specifying the colrs of the contour shading - The default values represent grayscale.}
}
\description{
\code{plot_avg_contour} calculates the conditional average of proportions or 
empirical logit looks to a given interest area by Time and a specified 
continuous variable. It then applies a 3D smooth 
(derived using \code{\link[mgcv]{gam}}) over 
the surface and plots the results as a contour plot.
}
\examples{
\dontrun{
library(VWPre)
# For plotting a conditional contour surface...
plot_avg_contour(data = dat, IA = "IA_1_ELogit", type = "elogit", 
               Var = "Rating", VarLabel = "Accent Rating", xlim = c(0,1000), 
               VWPreTheme = FALSE, Colors = c("red", "white"))
}
}
