% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_generators.R, R/ddv-ddu-base-copulas.R
\name{ddCopula}
\alias{ddCopula}
\alias{dduCopula}
\alias{ddvCopula}
\alias{dduCopula,matrix,normalCopula-method}
\alias{dduCopula,numeric,normalCopula-method}
\alias{ddvCopula,matrix,normalCopula-method}
\alias{ddvCopula,numeric,normalCopula-method}
\alias{dduCopula,matrix,tCopula-method}
\alias{dduCopula,numeric,tCopula-method}
\alias{ddvCopula,matrix,tCopula-method}
\alias{ddvCopula,numeric,tCopula-method}
\alias{dduCopula,matrix,gumbelCopula-method}
\alias{dduCopula,numeric,gumbelCopula-method}
\alias{ddvCopula,matrix,gumbelCopula-method}
\alias{ddvCopula,numeric,gumbelCopula-method}
\alias{dduCopula,matrix,claytonCopula-method}
\alias{dduCopula,numeric,claytonCopula-method}
\alias{ddvCopula,matrix,claytonCopula-method}
\alias{ddvCopula,numeric,claytonCopula-method}
\alias{dduCopula,matrix,indepCopula-method}
\alias{dduCopula,numeric,indepCopula-method}
\alias{ddvCopula,matrix,indepCopula-method}
\alias{ddvCopula,numeric,indepCopula-method}
\alias{dduCopula,matrix,frankCopula-method}
\alias{dduCopula,numeric,frankCopula-method}
\alias{ddvCopula,matrix,frankCopula-method}
\alias{ddvCopula,numeric,frankCopula-method}
\title{Partial Derivatives of Copulas}
\usage{
dduCopula(u, copula, ...)

\S4method{dduCopula}{matrix,normalCopula}(u, copula)

\S4method{dduCopula}{numeric,normalCopula}(u, copula, ...)

\S4method{ddvCopula}{matrix,normalCopula}(u, copula)

\S4method{ddvCopula}{numeric,normalCopula}(u, copula, ...)

\S4method{dduCopula}{matrix,tCopula}(u, copula)

\S4method{dduCopula}{numeric,tCopula}(u, copula, ...)

\S4method{ddvCopula}{matrix,tCopula}(u, copula)

\S4method{ddvCopula}{numeric,tCopula}(u, copula, ...)

\S4method{dduCopula}{matrix,gumbelCopula}(u, copula)

\S4method{dduCopula}{numeric,gumbelCopula}(u, copula, ...)

\S4method{ddvCopula}{matrix,gumbelCopula}(u, copula)

\S4method{ddvCopula}{numeric,gumbelCopula}(u, copula, ...)

\S4method{dduCopula}{matrix,claytonCopula}(u, copula)

\S4method{dduCopula}{numeric,claytonCopula}(u, copula, ...)

\S4method{ddvCopula}{matrix,claytonCopula}(u, copula)

\S4method{ddvCopula}{numeric,claytonCopula}(u, copula, ...)

\S4method{dduCopula}{matrix,indepCopula}(u, copula)

\S4method{dduCopula}{numeric,indepCopula}(u, copula, ...)

\S4method{ddvCopula}{matrix,indepCopula}(u, copula)

\S4method{ddvCopula}{numeric,indepCopula}(u, copula, ...)

\S4method{dduCopula}{matrix,frankCopula}(u, copula)

\S4method{dduCopula}{numeric,frankCopula}(u, copula, ...)

\S4method{ddvCopula}{matrix,frankCopula}(u, copula)

\S4method{ddvCopula}{numeric,frankCopula}(u, copula, ...)
}
\arguments{
\item{u}{Pairs of values for which the partial derivative should be
evaluated.}

\item{copula}{The copula object representing the family member of interest.}

\item{\dots}{additional arguments can be passed on to the underlying
functions.}
}
\value{
A vector of the evaluated partial derivatives of the same length as
rows in \code{u}.
}
\description{
Similar to \code{\link[=dCopula]{dCopula()}} and \code{\link[=pCopula]{pCopula()}} the function
\code{dduCopula} evaluates the partial derivative
\eqn{\frac{\partial}{\partial u} C(u,v)}{d C(u,v)/du} and the function
\code{ddvCopula} evaluates the partial derivative
\eqn{\frac{\partial}{\partial v} C(u,v)}{d C(u,v)/dv} of the provided
copula.
}
\examples{

library(copula)

BB1Cop <- BB1Copula()
BB1CopSmpl <- rCopula(100, BB1Cop)

# conditional probabilities of a Gaussian copula given u
BB1GivenU <- dduCopula(BB1CopSmpl, BB1Cop)

# vs. conditional probabilities of a Gaussian copula given v
BB1GivenV <- ddvCopula(BB1CopSmpl[, c(2, 1)], BB1Cop)

plot(BB1GivenU, BB1GivenV)
abline(0, 1)

}
\keyword{conditional}
\keyword{derivative}
\keyword{partial}
\keyword{probabilities}
