% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varmer.ts.R
\name{varmer.ts}
\alias{varmer.ts}
\title{Variational merging for time series}
\usage{
varmer.ts(
  x,
  x.metadata,
  v,
  lat = "lat",
  lon = "lon",
  drty.out = tempdir(),
  verbose = T
)
}
\arguments{
\item{x}{data.frame with the ground-based observation in time series format.
Every column must represent one ground-based station and the codes of the stations
must be provided as colnames. class(data) must be zoo.}

\item{x.metadata}{data.frame with the ground-based stations' metadata. At least,
it MUST have the following 3 columns:
id: This column stores the unique identifier (ID) of each ground observation. Default value is "id".
lat: This column stores the latitude of each ground observation. Default value is "lat".
lon: This column stores the longitude of each ground observation. Default value is "lon".}

\item{v}{The satellite-based or model-based gridded images
(in raster format, see \link[raster]{raster}). It can be a RasterStack or
RasterBrick object since it is supposed to containe multiple layers (time series).}

\item{lat}{A character string with the name of the column in x.metadata where the latitude of the stations is stored.}

\item{lon}{A character string with the name of the column in x.metadata where the longitude of the stations is stored.}

\item{drty.out}{A character string with the full path to the directory where the final merged products will be exported}

\item{verbose}{A logical which indicates if information messages are to be printed. By default \code{verbose=TRUE}}
}
\description{
It allows merging satellite-based or model-based grided images
(in raster format) with ground-based observed
time-series (in zoo format). This function is a wrapper for
the  function which allows to combine a product-based image with
an interpolated image from observations for a single time step.
}
