% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/V8.R
\name{new_context}
\alias{V8}
\alias{new_context}
\title{Run JavaScript in a V8 context}
\usage{
new_context(global = "global", console = TRUE, typed_arrays = TRUE)
}
\arguments{
\item{global}{character vector indicating name(s) of the global environment. Use NULL for no name.}

\item{console}{expose \code{console} API (\code{console.log}, \code{console.warn}, \code{console.error}).}

\item{typed_arrays}{enable support for typed arrays (part of ECMA6). This adds a bunch of additional
functions to the global namespace.}
}
\description{
A \emph{context} is an execution environment that allows separate, unrelated,
JavaScript code to run in a single instance of V8. You must explicitly specify
the context in which you want any JavaScript code to be run.
}
\details{
The \code{ct$eval} method evaluates a string of raw code in the same way
as \code{eval} would do in JavaScript. It returns a string with console output.
The \code{ct$get}, \code{ct$assign} and \code{ct$call} functions
on the other hand automatically convert arguments and return value from/to JSON,
unless an argument has been wrapped in \code{JS()}, see examples.
The \code{ct$validate} function is used to test if a piece of code is valid
JavaScript syntax within the context, and always returns TRUE or FALSE.

JSON is used for all data interchange beteen R and JavaScript. Therefore you can
(and should) only exchange data types that have a sensible JSON representation.
All aguments and objects are automatically converted according to the mapping
described in \href{http://arxiv.org/abs/1403.2805}{Ooms (2014)}, and implemented
by the jsonlite package in \code{\link{fromJSON}} and \code{\link{toJSON}}.

The name of the global object (i.e. \code{global} in node and \code{window}
in browsers) can be set with the global argument. A context always have a global
scope, even when no name is set. When a context is initiated with \code{global = NULL},
the global environment can be reached by evaluating \code{this} in the global scope,
for example: \code{ct$eval("Object.keys(this)")}.
}
\examples{
# Create a new context
ct <- new_context();

# Evaluate some code
ct$eval("var foo = 123")
ct$eval("var bar = 456")
ct$eval("foo+bar")

# Functions and closures
ct$eval("JSON.stringify({x:Math.random()})")
ct$eval("(function(x){return x+1;})(123)")

# Objects (via JSON only)
ct$assign("mydata", mtcars)
ct$get("mydata")

# Assign JavaScript
ct$assign("foo", JS("function(x){return x*x}"))
ct$assign("bar", JS("foo(9)"))
ct$get("bar")

# Validate script without evaluating
ct$validate("function foo(x){2*x}") #TRUE
ct$validate("foo = function(x){2*x}") #TRUE
ct$validate("function(x){2*x}") #FALSE

# Use a JavaScript library
ct$source(system.file("js/underscore.js", package="V8"))
ct$call("_.filter", mtcars, JS("function(x){return x.mpg < 15}"))

# Example from underscore manual
ct$eval("_.templateSettings = {interpolate: /\\\\{\\\\{(.+?)\\\\}\\\\}/g}")
ct$eval("var template = _.template('Hello {{ name }}!')")
ct$call("template", list(name = "Mustache"))

# Call anonymous function
ct$call("function(x, y){return x * y}", 123, 3)

\dontrun{CoffeeScript
ct2 <- new_context()
ct2$source("http://coffeescript.org/extras/coffee-script.js")
jscode <- ct2$call("CoffeeScript.compile", "square = (x) -> x * x", list(bare = TRUE))
ct2$eval(jscode)
ct2$call("square", 9)

# Interactive console
ct3 <- new_context()
ct3$console()
//this is JavaScript
var test = [1,2,3]
JSON.stringify(test)
exit}
}
\references{
A Mapping Between JSON Data and R Objects (Ooms, 2014): \url{http://arxiv.org/abs/1403.2805}
}

