% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_Histograma.R
\name{Plot.Histograma}
\alias{Plot.Histograma}
\title{Cree un histograma que represente gráficamente la distribución de datos en un
conjunto, facilitando la comprensión de su frecuencia y patrones con dos
diferentes paquetes.}
\usage{
Plot.Histograma(
  datos,
  variable,
  color,
  bins,
  density = FALSE,
  titulo = "",
  xlim,
  ylim,
  labelX = NULL,
  labelY = "Conteo",
  libreria = c("highcharter", "plotly"),
  estilo = NULL,
  estatico = FALSE
)
}
\arguments{
\item{datos}{Un data frame, no un objeto clase serie de tiempo o vector numérico.}

\item{variable}{Una variable numérica dentro del data frame ingresado en \code{datos}.}

\item{color}{Cadena de caracteres indicando el color de relleno de las barras
para todos los rangos de valores (intervalos).}

\item{bins}{Valor numérico que indica el número máximo de bins deseado. Este
valor se utilizará en un algoritmo que decidirá el tamaño de bins óptimo para
que el histograma visualice mejor la distribución de los datos.}

\item{density}{Si es \code{TRUE} se agregará la curva de densidad superpuesta al
histograma. El valor por defecto es \code{FALSE}.}

\item{titulo}{Cadena de caracteres indicando el título principal del plot.}

\item{xlim}{Vector numérico que especifica el límite inferior y superior,
respectivamente, del eje \code{X}. Si no se introduce algún valor se mostrará
todo el rango disponible para dicho eje.}

\item{ylim}{Vector numérico que especifica el límite inferior y superior,
respectivamente, del eje \code{Y}. Si no se introduce algún valor se mostrará
todo el rango disponible para dicho eje.}

\item{labelX}{Cadena de caracteres indicando la etiqueta del eje \code{X}. Por
defecto se emplea el rótulo "Periodo".}

\item{labelY}{Cadena de caracteres indicando la etiqueta del eje \code{Y}.}

\item{libreria}{Cadena de caracteres que indica el paquete con el cual se
realizará la serie. Los valores permitidos son \code{"highcharter"}
(\emph{valor predeterminado}), \code{"plotly"} o \code{"dygraphs"}. Los valores se emparejarán
parcialmente.}

\item{estilo}{Lista compuesta por varios parámetros, los cuales van a ser usados
de acuerdo con la librería especificada para graficar el plot y cuyo objetivo
es personalizar pequeños detalles de ésta.
\itemize{
\item \code{hc.Tema}, \code{ply.Credits}, \code{gg.Tema} y \code{gg.Texto}: Igual uso
que en \code{\link[=Plot.Series]{Plot.Series()}}
\item \code{ply.Density}: Una lista de parámetros admitidos por el argumento \code{line}
de la función \link[plotly:add_trace]{add_lines()}.
\item \code{gg.Hist}: Una lista de parámetros admitidos por la función \link[ggplot2:geom_histogram]{geom_histogram()}.
\item \code{gg.Density}: Una lista de parámetros admitidos por la función \link[ggplot2:geom_density]{geom_density()}.
}}

\item{estatico}{Si es \code{FALSE} (\emph{valor predeterminado}) el gráfico a retornar
será dinámico (\emph{dependiendo de la librería seleccionada}), en caso contrario
se retornará un gráfico estático construido con \code{ggplot2}.}
}
\value{
Retorna el histograma (\emph{objeto widget de HTML}) creado. La clase del objeto
retornado será un "htmlwidget" y dependiendo de la librería usada pertenecerá
adicionalmente a la clase "highchart" o "plotly".
}
\description{
Esta función proporciona excelentes herramientas y opciones para la visualización
de un histograma, con el objetivo de que pueda representar la distribución de
frecuencia de datos numéricos (\emph{variable de un conjunto de datos}) en forma de
barras, donde cada barra representa la cantidad de veces que aparece un valor
o rango de valores. Dicho diagrama se puede representar usando dos diferentes
librerías que son \code{Highcharter} y \code{Plotly}, las cuales usan internamente \code{JavaScript}.
}
\details{
\itemize{
\item Al usar la librería \code{Highcharter} no se podrá superponer la curva de densidad,
pues no se dispone de esta funcionalidad para dicho paquete.
\item Si está usando el caso estático (\code{ggplot2}) y adicionalmente está graficando
la curva de densidad, recuerde que el eje \code{Y} que predomina es el de la curva
de densidad, por tal razón, si va a usar el argumento \code{ylim} debe recordar
que quedara en la escala de \eqn{[0, 1]}.
\item Tenga cuidado al usar el argumento \code{xlim} en el caso estático, ya que si uno
de los bins se ve cortado (\emph{no abarca el inicio y fin de éste}) no se graficará
dicho intervalo.
\item Al usar el paquete \code{Highcharter} y usar las opciones de descarga, el nombre
del archivo descargado será la concatenación del plot graficado y la categoría
usada, así, por ejemplo, si se graficó el diagrama de barras para la categoría
"Nacionalidad" el nombre será \code{PlotHistograma__Nacionalidad.png}.
}
}
\section{Lista de argumentos de estilo}{


Sabemos que puede ser abrumador el número de argumentos dentro del parámetro
\code{estilo}, pero es necesario si queremos ofrecer al usuario la máxima
personalización dentro de cada función usando cualquier librería. Por tal
razón, a continuación, se detalla el listado completo de argumentos, usados
al especificar la librería y en qué función están presentes
(\emph{marcado con una × si lo posee}).\tabular{clcccccccc}{
   \strong{Librería} \tab \strong{estilo$} \tab \code{\link[=Plot.Series]{Plot.Series()}} \tab \code{\link[=Plot.Barras]{Plot.Barras()}} \tab \code{\link[=Plot.Apiladas]{Plot.Apiladas()}} \tab \code{\link[=Plot.Boxplot]{Plot.Boxplot()}} \tab \code{\link[=Plot.Radar]{Plot.Radar()}} \tab \code{\link[=Plot.Treemap]{Plot.Treemap()}} \tab \code{\link[=Plot.Torta]{Plot.Torta()}} \tab \code{\link[=Plot.Drilldown]{Plot.Drilldown()}} \cr
   — \tab \emph{gg.Tema} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Texto} \tab × \tab × \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Legend} \tab × \tab  \tab × \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Linea} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Punto} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Bar} \tab  \tab × \tab × \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.VarWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.OutShape} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitWidth} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.JitSize} \tab  \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   l \tab \emph{gg.Range} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{ggplot2} \tab \emph{gg.plty} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.plwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglwd} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.cglcol} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{gg.fontsize.title} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontsize.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.fontcolor.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.lwds} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.border.col} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.lowerbound.cex.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   l \tab \emph{gg.force.print.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   — \tab \emph{gg.overlap.labels} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   » \tab \emph{hc.Tema} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   l \tab \emph{hc.Credits} \tab × \tab × \tab × \tab × \tab  \tab × \tab × \tab × \cr
   \strong{highcharter} \tab \emph{hc.BoxInfo} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   l \tab \emph{hc.Slider} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{hc.borderRadius} \tab  \tab  \tab  \tab  \tab  \tab × \tab  \tab  \cr
   • \tab \emph{ply.Credits} \tab × \tab × \tab × \tab × \tab × \tab × \tab × \tab  \cr
   ° \tab \emph{ply.Legend} \tab  \tab × \tab  \tab  \tab  \tab  \tab × \tab  \cr
   ° \tab \emph{ply.LegendPosition} \tab × \tab  \tab × \tab × \tab × \tab  \tab  \tab  \cr
   \strong{plotly} \tab \emph{ply.Interaction} \tab × \tab  \tab  \tab × \tab  \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Relleno} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   ° \tab \emph{ply.Opacidad} \tab  \tab  \tab  \tab  \tab × \tab × \tab  \tab  \cr
   • \tab \emph{ply.LegendTitle} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{dygraphs} \tab \emph{dyg.LegendWidth} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   » \tab \emph{dyg.Resaltar} \tab × \tab  \tab  \tab  \tab  \tab  \tab  \tab  \cr
   — \tab \emph{e.Tema} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.Credits} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   \strong{echarts4r} \tab \emph{e.Forma} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   l \tab \emph{e.LegType} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
   — \tab \emph{e.LegLoc} \tab  \tab  \tab  \tab  \tab × \tab  \tab  \tab  \cr
}
}

\examples{
Txt <- "Datos Oficiales de la Prueba Saber Pro del año 2020"
Plot.Histograma(
  datos    = ejSaberPro2020,
  variable = PUNT_RAZO_CUANT,
  color    = "#12D640",
  bins     = 100,
  titulo   = "DISTRIBUCI\u00d3N EN EL PUNTAJE DE RAZONAMIENTO CUANTITATIVO",
  ylim     = c(0, 175),
  labelX   = "Puntaje en Matem\u00e1ticas",
  labelY   = "N\u00famero de Estudiantes",
  libreria = "highcharter",
  estilo   = list(hc.Tema  = 4)
)
# ---------------------------------------------------------------------------
Plot.Histograma(
  datos    = ejSaberPro2020,
  variable = PUNT_RAZO_CUANT,
  color    = "#B9ABD1",
  bins     = 80,
  density  = TRUE,
  titulo   = "DISTRIBUCI\u00d3N EN EL PUNTAJE\nDE RAZONAMIENTO CUANTITATIVO",
  ylim     = c(0, 400),
  labelX   = "Puntaje en Matem\u00e1ticas",
  labelY   = "N\u00famero de Estudiantes",
  libreria = "plotly",
  estilo   = list(
    ply.Credits = list(x = 0.5, y = 1.1, text = Txt),
    ply.Density = list(color = "#DD3380", width = 4, dash = "dot", opacity = 0.2)
  )
)
# ---------------------------------------------------------------------------
# Ejemplo usando el caso estático (ggplot2)
Plot.Histograma(
  datos    = ejSaberPro2020,
  variable = PUNT_RAZO_CUANT,
  density  = TRUE,
  titulo   = "DISTRIBUCI\u00d3N EN EL PUNTAJE DE RAZONAMIENTO CUANTITATIVO",
  labelX   = "Puntaje en Matem\u00e1ticas",
  labelY   = "N\u00famero de Estudiantes",
  estatico = TRUE,
  estilo   = list(
    gg.Tema    = 6,
    gg.Hist    = list(
      binwidth = 10, fill = "#FF4040", color = "#144169", alpha = 0.5, linetype = "dashed"
    ),
    gg.Density = list(color = "#20B2AA", fill = "#40E0D0", alpha = 0.4, lwd = 1.1, linetype = 2),
    gg.Texto   = list(subtitle = "\u00bb\u00bb\u00bb", tag = "\u00ae", caption  = Txt)
  )
)

}
