% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Cal_elec}
\alias{Cal_elec}
\title{Demand for California Independent System Operator (CISO)}
\format{A tsibble object with hourly intervals}
\source{
US Energy Information Administration (Dec 2019) \href{https://www.eia.gov/}{website}
}
\usage{
Cal_elec
}
\description{
The demand for electricity in California subregion since July 2018 by operator.

Units: megawatthours

Time zone: UTC
}
\details{
The dataset contains the hourly demand for electricity in the California subregion (megawatthours).
The `operator` column describes the name of operator provider
}
\examples{

data(Cal_elec)

library(plotly)

plot_ly(data = Cal_elec,
        x = ~ date_time,
        y = ~ series,
        color = ~ operator,
        type = "scatter",
        mode = "lines")

}
\keyword{datasets}
\keyword{time-series}
