% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_plane.R
\name{state_plane}
\alias{state_plane}
\title{Projections from the State Plane Coordinate System}
\usage{
state_plane(state, plane_id = NULL, type = c("epsg", "proj4"))
}
\arguments{
\item{state}{The postal code for the state.}

\item{plane_id}{The state plane geographic zone identifier. A \code{NULL}
value will return a projection for the entire state.}

\item{type}{The type of output to return: either an EPSG code or PROJ4
string.}
}
\value{
Either a PROJ4 string as a character vector or an EPSG code as an
  integer.
}
\description{
Get EPSG codes or PROJ.4 codes for projections from the
\href{https://en.wikipedia.org/wiki/State_Plane_Coordinate_System}{State
Plane Coordinate System}.
}
\examples{
if (require(USAboundariesData)) {
  state_plane(state = "MA", type = "epsg")
  state_plane(state = "MA", type = "proj4")
  state_plane(state = "MA", plane_id = "island", type = "epsg")
  state_plane(state = "MA", plane_id = "island", type = "proj4")

  # Show the difference made by a state plane projection
  if (require(sf)) {
    va <- us_states(states = "VA", resolution = "high")
    plot(st_geometry(va), graticule = TRUE)
    va <- st_transform(va, state_plane("VA"))
    plot(st_geometry(va), graticule = TRUE)
  }
}

}
\seealso{
For documentation of the underlying State Plane Coordinate System
  projection data frame, see \code{\link{state_proj}}.
}
