% Generated by roxygen2 (4.0.2): do not edit by hand
\name{analyse_randomKde2d_smart}
\alias{analyse_randomKde2d_smart}
\title{Perform analysis of random 2d distributions}
\usage{
analyse_randomKde2d_smart(nfields=100, nstars, maxX, maxY, nKde=50,
showStats=FALSE, returnStats=TRUE, smartTableDB)
}
\arguments{
\item{nfields}{an integer with the number of individual field realisations}

\item{nstars}{an integer with the number of stars to consider}

\item{maxX}{the length of the field in X}

\item{maxY}{the length of the field in Y}

\item{nKde}{the number of samplings of the kernel in each direction}

\item{showStats}{a boolean indicating if the user wants to see statistics}

\item{returnStats}{a boolean indicating if the user wants statistics to be returned}

\item{smartTableDB}{a database connection to the smart look-up table}
}
\value{
A data frame with the \code{mean} and \code{sd} fields containing the results
of the random field analysis.
}
\description{
\code{analyse_randomKde2d_smart} will compute statistics from uniformly
randomly created 2D fields based on Kernel Density Estimations (calling the code
\code{\link{analyse_randomKde2d}}). However, if a random field using the same number of stars
was already computed in this run of UPMASK, it will avoid computing it again and will
return the value that is stored in a SQLite database table. If the random field was
not yet analysed, it will run the analysis, store the result in the database table, and
return the value.
}
\examples{
# Create the smart look-up table
library(RSQLite)
stcon <- create_smartTable()

# Runs the analysis on random fields
system.time(
toyRes1 <- analyse_randomKde2d_smart(300, 200, 100, 100, smartTableDB=stcon)) # slow
system.time(
toyRes2 <- analyse_randomKde2d_smart(300, 200, 100, 100, smartTableDB=stcon)) # quick

# Clean the environment
rm(list=c("toyRes1", "toyRes2"))
dbDisconnect(stcon)
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\keyword{utilities}

